/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

class BISDeviceUUIDFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static volatile UUID uuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BISDeviceUUIDFactory(Context context) {
        if (uuid != null) return;
        Class<BISDeviceUUIDFactory> clazz = BISDeviceUUIDFactory.class;
        synchronized (BISDeviceUUIDFactory.class) {
            if (uuid != null) return;
            SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 0);
            String id = prefs.getString(PREFS_DEVICE_ID, null);
            if (id != null) {
                uuid = UUID.fromString(id);
            } else {
                String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                try {
                    String deviceId;
                    uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")) : ((deviceId = ((TelephonyManager)context.getSystemService("phone")).getDeviceId()) != null ? UUID.nameUUIDFromBytes(deviceId.getBytes("utf8")) : UUID.randomUUID());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                prefs.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public UUID getDeviceUuid() {
        return uuid;
    }
}

