/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.location.Location;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorAsyncRequest;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import com.beaconsinspace.android.beacon.detector.BISLocationListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import org.altbeacon.beacon.Beacon;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BISDetectorREST {
    static final String TAG = "BIS_REST";
    static String BIS_URL_EVENT = "https://api.beaconsinspace.com/v1/event";
    static String BIS_URL_BEACON = "https://api.beaconsinspace.com/v1/beacon?userId=%s&userIdType=%s&userId2=%s&userIdType2=%s&os=%s&device=%s&tz=%s&language=%s&country=%s&sdkVersion=%s&createdAt=%f";
    static BISDetectorInternalDelegate delegate;

    BISDetectorREST() {
    }

    public static void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    public static ArrayList<String> getBeaconsInfoFromServer() {
        Log.i((String)TAG, (String)"Getting beacon identifiers from BeaconsInSpace API");
        String responseString = BISDetectorREST.getBeaconsList();
        if (responseString == null || responseString.length() == 0) {
            BISDetector.sharedInstance.onBeaconsInfoReceiveFail(503, null);
            return null;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        try {
            JSONObject jsonObject = new JSONObject(responseString);
            int responseCode = jsonObject.getInt("code");
            if (responseCode != 200) {
                BISDetector.sharedInstance.onBeaconsInfoReceiveFail(responseCode, null);
                return null;
            }
            JSONArray jsonArrayData = jsonObject.getJSONArray("data");
            if (jsonArrayData == null) {
                return null;
            }
            for (int i = 0; i < jsonArrayData.length(); ++i) {
                String uuid;
                JSONObject jsonObjectBeacon = jsonArrayData.getJSONObject(i);
                String protocol = jsonObjectBeacon.getString("protocol");
                if (!protocol.equalsIgnoreCase("ibeacon") || (uuid = jsonObjectBeacon.getString("uuid")) == null) continue;
                uuids.add(uuid);
            }
            if (uuids.size() > 0) {
                BISDetector.beaconsManager().updateUUIDs(uuids);
                if (delegate != null) {
                    delegate.onBeaconsInfoReceiveSuccess();
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("JSONException: " + e.getMessage()));
            BISDetector.sharedInstance.onBeaconsInfoReceiveFail(503, null);
        }
        return uuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBeaconsList() {
        String os = "";
        String device = "";
        String tz = "";
        String sdkVersion = "";
        String language = "";
        String country = "";
        try {
            os = "ANDROID" + URLEncoder.encode(" " + Build.VERSION.RELEASE, "UTF-8");
            device = URLEncoder.encode(Build.BRAND + " " + Build.DEVICE, "UTF-8");
            tz = TimeZone.getDefault().getID();
            sdkVersion = BISDetector.SDK_VERSION;
            language = Locale.getDefault().toString();
            country = Locale.getDefault().toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("UnsupportedEncodingException: " + e.getMessage()));
        }
        String urlToCall = String.format(BIS_URL_BEACON, BISDetector.UUID.toString(), "AUUID", BISDetector.ADID, "ADID", os, device, tz, language, country, sdkVersion, (double)System.currentTimeMillis() / 1000.0);
        BISDetectorAsyncRequest urlCaller = new BISDetectorAsyncRequest();
        String responseString = null;
        try {
            urlCaller.execute(new String[]{urlToCall});
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("IllegalStateException: " + e.getMessage()));
        }
        finally {
            try {
                responseString = (String)urlCaller.get();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)("InterruptedException: " + e.getMessage()));
            }
            catch (ExecutionException e) {
                Log.e((String)TAG, (String)("ExecutionException: " + e.getMessage()));
            }
        }
        return responseString;
    }

    public static String notifyAboutBeaconEnter(Beacon beacon) {
        return BISDetectorREST.callEventURL(beacon, true);
    }

    public static String notifyAboutBeaconExit(Beacon beacon) {
        return BISDetectorREST.callEventURL(beacon, false);
    }

    private static String callEventURL(Beacon beacon, boolean isEnter) {
        String[] beaconIds = BISDetectorManager.idsForBeacon(beacon);
        String beaconId = BISDetectorManager.uniqueIdentifierForBeacon(beacon);
        if (beaconIds == null || beaconIds.length < 3) {
            return null;
        }
        String tz = TimeZone.getDefault().getID();
        String dataString = String.format("uuid=%s&major=%s&minor=%s&userId=%s&userIdType=%s&userId2=%s&userIdType2=%s&detect=%s&tz=%s&createdAt=%f", beaconIds[0], beaconIds[1], beaconIds[2], BISDetector.UUID.toString() != null ? BISDetector.UUID.toString() : "", "AUUID", BISDetector.ADID != null ? BISDetector.ADID : "", "ADID", isEnter ? "enter" : "exit", tz, (double)System.currentTimeMillis() / 1000.0);
        Location location = BISLocationListener.getLocationByBeaconId(beaconId);
        if (location != null) {
            float latitude = (float)location.getLatitude();
            float longitude = (float)location.getLongitude();
            dataString = dataString + "&gpsLatitude=" + latitude + "&gpsLongitude=" + longitude;
        }
        final String finalDataString = dataString;
        final String[] resultStringData = new String[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                resultStringData[0] = BISDetectorREST.sendData(finalDataString);
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)("callEventURL thread error:" + e.getMessage()));
        }
        return resultStringData[0];
    }

    static String getAuthorizationHeader() {
        String USER_KEY = BISDetector.API_KEY;
        String PACKAGE_NAME = BISDetector.context != null ? BISDetector.context.getPackageName() : "";
        String authString = USER_KEY + ":" + PACKAGE_NAME;
        byte[] authBytes = authString.getBytes();
        String base64AuthString = Base64.encodeToString((byte[])authBytes, (int)0, (int)authString.length(), (int)2);
        String authorizationHeader = "Basic " + base64AuthString;
        return authorizationHeader;
    }

    static String sendData(String data) {
        if (data == null) {
            return null;
        }
        String url = BIS_URL_EVENT;
        String result = null;
        String authorizationHeader = BISDetectorREST.getAuthorizationHeader();
        try {
            String line;
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Authorization", authorizationHeader);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestMethod("POST");
            urlConnection.connect();
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(data);
            writer.close();
            outputStream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            result = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("UnsupportedEncodingException: " + e.getMessage()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException: " + e.getMessage()));
        }
        return result;
    }
}

