/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.mozilla.intl.chardet;

import bboss.org.mozilla.intl.chardet.nsDetector;
import bboss.org.mozilla.intl.chardet.nsICharsetDetectionObserver;
import com.frameworkset.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import org.frameworkset.util.FileCopyUtils;

public class UTF8Convertor {
    private StringBuilder buffer = new StringBuilder();

    public String getUnknown() {
        return this.buffer.toString();
    }

    private boolean contain(String[] excludedirs, String name) {
        for (int i = 0; excludedirs != null && i < excludedirs.length; ++i) {
            if (!name.equals(excludedirs[i])) continue;
            return true;
        }
        return false;
    }

    private boolean endwith(String[] excludedirs, String name) {
        for (int i = 0; excludedirs != null && i < excludedirs.length; ++i) {
            if (!name.endsWith(excludedirs[i])) continue;
            return true;
        }
        return false;
    }

    public void convertCharsetToUtf_8(String dir, final String[] excludedirs, final String[] includefiles) {
        File root = new File(dir);
        File[] files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return !UTF8Convertor.this.contain(excludedirs, arg0.getName());
                }
                return UTF8Convertor.this.endwith(includefiles, arg0.getName());
            }
        });
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i].isFile()) {
                    this.doconvert(files[i]);
                    continue;
                }
                this.convertCharsetToUtf_8(files[i].getCanonicalPath(), excludedirs, includefiles);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void convertCharsetToUtf_8(String dir) {
        this.convertCharsetToUtf_8(dir, new String[]{".svn", "classes", ".settings", "\u6587\u6863", "dbinit-system", "distrib", "doc", "lib", "lib-client", "lib-compile"}, new String[]{".jsp", ".java", ".js", ".css", ".txt", ".properties", ".html", ".htm", ".tld", ".vm", ".xml"});
    }

    public static String takecharset(String test) throws UnsupportedEncodingException {
        return UTF8Convertor.takecharset(test.getBytes("ISO-8859-1"));
    }

    public static String takecharset(byte[] test) throws UnsupportedEncodingException {
        final Found found = new Found();
        int lang = 0;
        nsDetector det = new nsDetector(lang);
        det.Init(new nsICharsetDetectionObserver(){

            @Override
            public void Notify(String charset) {
                found.setFound(true);
                found.setCharset(charset);
            }
        });
        boolean done = false;
        boolean isAscii = true;
        if (isAscii) {
            isAscii = det.isAscii(test, test.length);
        }
        if (!isAscii && !done) {
            done = det.DoIt(test, test.length, false);
        }
        det.DataEnd();
        if (isAscii) {
            found.setFound(true);
        }
        if (found.isFound()) {
            String[] prob = det.getProbableCharsets();
            String charset = found.getCharset();
            if (charset != null) {
                return prob != null && prob.length > 0 ? prob[0] : charset;
            }
            return prob != null && prob.length > 0 ? prob[0] : charset;
        }
        String[] prob = det.getProbableCharsets();
        boolean isutf8 = false;
        boolean containgbk = false;
        for (int i = 0; prob != null && i < prob.length; ++i) {
            if (prob[i].equals("UTF-8")) {
                isutf8 = true;
                break;
            }
            if (!prob[i].startsWith("GB")) continue;
            containgbk = true;
            if (isutf8) break;
        }
        if (!isutf8 && containgbk) {
            return "GBK";
        }
        if (isutf8) {
            return "UTF-8";
        }
        return prob != null && prob.length > 0 ? prob[0] : null;
    }

    public static String takefilecharset(File f) throws Exception {
        return UTF8Convertor.takeurlcharset(f.toURL());
    }

    public static String takeurlcharset(URL url) throws Exception {
        int len;
        final Found found = new Found();
        int lang = 0;
        nsDetector det = new nsDetector(lang);
        det.Init(new nsICharsetDetectionObserver(){

            @Override
            public void Notify(String charset) {
                found.setFound(true);
                found.setCharset(charset);
            }
        });
        BufferedInputStream imp = new BufferedInputStream(url.openStream());
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            found.setFound(true);
        }
        if (found.isFound()) {
            String[] prob = det.getProbableCharsets();
            String chars = found.getCharset();
            if (chars != null) {
                return chars;
            }
            if (prob != null && prob.length > 0) {
                return prob[0];
            }
            return null;
        }
        String[] prob = det.getProbableCharsets();
        boolean isutf8 = false;
        boolean containgbk = false;
        for (int i = 0; prob != null && i < prob.length; ++i) {
            if (prob[i].equals("UTF-8")) {
                isutf8 = true;
                continue;
            }
            if (!prob[i].startsWith("GB")) continue;
            containgbk = true;
        }
        if (!isutf8 && containgbk) {
            return "GBK";
        }
        if (isutf8) {
            return "UTF-8";
        }
        return prob != null && prob.length > 0 ? prob[0] : null;
    }

    public void doconvert(File f) throws Exception {
        int len;
        final Found found = new Found();
        int lang = 0;
        nsDetector det = new nsDetector(lang);
        det.Init(new nsICharsetDetectionObserver(){

            @Override
            public void Notify(String charset) {
                found.setFound(true);
                found.setCharset(charset);
            }
        });
        URL url = f.toURL();
        BufferedInputStream imp = new BufferedInputStream(url.openStream());
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            found.setFound(true);
        }
        if (found.isFound()) {
            String[] prob = det.getProbableCharsets();
            if (found.getCharset() != null && found.getCharset().startsWith("GB")) {
                UTF8Convertor.convertfilecharset(f, "GBK", "UTF-8");
            } else if (prob != null && prob.length > 0 && prob[0].startsWith("GB")) {
                UTF8Convertor.convertfilecharset(f, "GBK", "UTF-8");
            }
        } else {
            String[] prob = det.getProbableCharsets();
            this.buffer.append("file=").append(f.getCanonicalPath()).append(",charset[\r\n");
            boolean isutf8 = false;
            boolean containgbk = false;
            for (int i = 0; prob != null && i < prob.length; ++i) {
                if (prob[i].equals("UTF-8")) {
                    isutf8 = true;
                } else if (prob[i].startsWith("GB")) {
                    containgbk = true;
                }
                this.buffer.append(prob[i]).append(",");
            }
            if (!isutf8 && containgbk) {
                UTF8Convertor.convertfilecharset(f, "GBK", "UTF-8");
            }
            this.buffer.append("]\r\n");
        }
    }

    public static void convertfilecharset(File f, String srccharset, String destcharset) throws IOException {
        String test = FileUtil.getFileContent(f, srccharset);
        FileCopyUtils.copy(test, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(f), destcharset));
    }

    public static void main(String[] args) throws Exception {
        UTF8Convertor convertor = new UTF8Convertor();
        convertor.convertCharsetToUtf_8("D:\\ewebeditor", new String[]{".svn"}, new String[]{".css", ".js", ".htm", ".html", ".jsp"});
        System.out.println(convertor.getUnknown());
    }

    public static class Found {
        private boolean found = false;
        private String charset = null;

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }
    }
}

