/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.commons.dbcp2.AbandonedTrace;
import com.frameworkset.commons.dbcp2.DelegatingConnection;
import com.frameworkset.commons.dbcp2.DelegatingPreparedStatement;
import com.frameworkset.commons.dbcp2.SQLExceptionList;
import com.frameworkset.commons.pool2.KeyedObjectPool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    private final KeyedObjectPool<K, PoolablePreparedStatement<K>> pool;
    private final K key;
    private volatile boolean batchAdded = false;

    public PoolablePreparedStatement(PreparedStatement stmt, K key, KeyedObjectPool<K, PoolablePreparedStatement<K>> pool, DelegatingConnection<?> conn) {
        super(conn, stmt);
        this.pool = pool;
        this.key = key;
        this.removeThisTrace(this.getConnectionInternal());
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.pool.returnObject(this.key, this);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", e);
            }
        }
    }

    @Override
    public void activate() throws SQLException {
        this.setClosedInternal(false);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().addTrace(this);
        }
        super.activate();
    }

    @Override
    public void passivate() throws SQLException {
        if (this.batchAdded) {
            this.clearBatch();
        }
        this.setClosedInternal(true);
        this.removeThisTrace(this.getConnectionInternal());
        List<AbandonedTrace> resultSetList = this.getTrace();
        if (resultSetList != null) {
            ResultSet[] resultSets;
            ArrayList<Exception> thrown = new ArrayList<Exception>();
            for (ResultSet resultSet : resultSets = resultSetList.toArray(new ResultSet[resultSetList.size()])) {
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    thrown.add(e);
                }
            }
            this.clearTrace();
            if (!thrown.isEmpty()) {
                throw new SQLExceptionList(thrown);
            }
        }
        super.passivate();
    }
}

