/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigParser
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(ConfigParser.class);
    private ArrayList dbProps;
    private ArrayList genericProps;
    private Properties adminProps;
    private boolean jmxManagement = false;
    private String currentSet;
    private String currentName;
    private StringBuilder currentValue = new StringBuilder();
    private String file;
    private String[] filterdbname = null;
    private String interceptor = "com.frameworkset.common.poolman.interceptor.DummyInterceptor";
    private String currentdbtype;
    private String dbnamespace;
    private String refreshinterval;
    protected PropertiesContainer configPropertiesFile;
    protected String sqlMappingDir;
    private Map<String, String> adaptors = new HashMap<String, String>();
    private List<Properties> filterpros = null;

    public String getRefreshinterval() {
        return this.refreshinterval;
    }

    public ConfigParser(String file, String dbnamespace, String[] filterdbname) {
        this.dbProps = new ArrayList();
        this.genericProps = new ArrayList();
        this.file = file;
        this.filterdbname = filterdbname;
        this.dbnamespace = dbnamespace;
    }

    public String getSqlMappingDir() {
        return this.sqlMappingDir;
    }

    public ArrayList getDataSourceProperties() {
        if (this.filterdbname != null && this.filterdbname.length > 0) {
            this.dbProps.clear();
            if (this.filterpros != null && this.filterpros.size() > 0) {
                this.dbProps.addAll(this.filterpros);
            }
        }
        return this.dbProps;
    }

    public ArrayList getGenericProperties() {
        return this.genericProps;
    }

    public Properties getAdminProps() {
        return this.adminProps;
    }

    public boolean isManagementJMX() {
        return this.jmxManagement;
    }

    @Override
    public void startElement(String s1, String s2, String name, Attributes attributes) {
        this.currentValue.delete(0, this.currentValue.length());
        this.currentName = name;
        if (name.toLowerCase().equals("datasource")) {
            this.currentSet = "datasource";
            Properties properties = new Properties();
            String external = SimpleStringUtil.replaceNull((String)attributes.getValue("external"), (String)"false");
            properties.put("external", external);
            this.dbProps.add(properties);
        } else if (name.equals("config")) {
            String file;
            if (this.configPropertiesFile == null) {
                this.configPropertiesFile = new PropertiesContainer();
            }
            if ((file = attributes.getValue("file")) != null) {
                this.configPropertiesFile.addConfigPropertiesFile(file);
            }
        } else if (name.toLowerCase().equals("objectpool")) {
            this.currentSet = "generic";
            this.genericProps.add(new Properties());
        } else if (name.toLowerCase().equals("admin-agent")) {
            this.currentSet = "admin-agent";
            this.adminProps = new Properties();
        } else if (name.toLowerCase().equals("management-mode")) {
            this.currentSet = "management-mode";
        } else if (name.equals("poolman") || name.equals("MLET")) {
            this.currentSet = "ignorable";
        } else if (name.toLowerCase().equals("jndi_principal")) {
            this.currentSet = "jndi_principal";
        } else if (name.equals("jndi_credentials")) {
            this.currentSet = "jndi_credentials";
        } else if (name.toLowerCase().equals("adaptor")) {
            this.currentSet = "adaptor";
            this.currentdbtype = attributes.getValue("dbtype");
        } else if (!(name.equals("dbname") || name.equals("loadmetadata") || name.equals("jndiName") || name.equals("driver") || name.equals("url") || name.equals("username") || name.equals("password") || name.equals("txIsolationLevel") || name.equals("nativeResults") || name.equals("poolPreparedStatements") || name.equals("initialConnections") || name.equals("minimumSize") || name.equals("maximumSize") || name.equals("maximumSoft") || name.equals("removeAbandoned") || name.equals("userTimeout") || name.equals("logAbandoned") || name.equals("readOnly") || name.equals("skimmerFrequency") || name.equals("connectionTimeout") || name.equals("shrinkBy") || name.equals("testWhileidle") || name.equals("keygenerate") || name.equals("maxWait") || name.equals("validationQuery") || name.equals("autoprimarykey") || name.equals("cachequerymetadata") || name.equals("showsql") || name.equals("externaljndiName") || name.equals("enablejta") || name.equals("usepool") || name.equals("encryptdbinfo") || name.equals("datasourceFile") || name.equals("queryfetchsize") || name.equals("config") || name.equals("needtableinfo") || name.equals("refreshinterval") || name.equals("dbInfoEncryptClass") || name.equals("columnNameMapping") || name.equals("sqlMappingDir") || !log.isDebugEnabled())) {
            log.debug("\u89e3\u6790\u6587\u4ef6\u65f6[" + this.file + "]\u9047\u5230\u5143\u7d20[" + name + "]\uff0c\u5ffd\u7565\u5904\u7406\u3002");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    private boolean contain(String newdbname) {
        if (this.filterpros == null || this.filterpros.size() == 0) {
            return false;
        }
        for (Properties p : this.filterpros) {
            String dbname = (String)p.get("dbname");
            if (!dbname.equals(newdbname)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endElement(String s1, String s2, String name) {
        block10: {
            int n;
            String[] stringArray;
            String temp;
            Properties p;
            block13: {
                block23: {
                    block22: {
                        block21: {
                            block19: {
                                block20: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block11: {
                                                            block12: {
                                                                String dbname;
                                                                if (!this.currentSet.equals("datasource")) break block11;
                                                                p = (Properties)this.dbProps.get(this.dbProps.size() - 1);
                                                                if (!name.toLowerCase().equals("dbname")) break block12;
                                                                temp = dbname = this.currentValue.toString().trim();
                                                                if (this.dbnamespace != null && !this.dbnamespace.equals("")) {
                                                                    dbname = this.dbnamespace + ":" + this.currentValue.toString().trim();
                                                                }
                                                                p.put(name.toLowerCase(), dbname);
                                                                if (this.filterdbname == null || this.filterdbname.length <= 0) break block10;
                                                                stringArray = this.filterdbname;
                                                                n = stringArray.length;
                                                                break block13;
                                                            }
                                                            String value = null;
                                                            value = this.configPropertiesFile != null ? this.configPropertiesFile.evalValue((List)null, this.currentValue.toString().trim(), null) : this.currentValue.toString().trim();
                                                            if (!name.equals("password")) {
                                                                p.put(name.toLowerCase(), value.trim());
                                                                break block10;
                                                            } else {
                                                                p.put(name.toLowerCase(), value);
                                                            }
                                                            break block10;
                                                        }
                                                        if (!this.currentSet.equals("generic")) break block14;
                                                        Properties p2 = (Properties)this.genericProps.get(this.genericProps.size() - 1);
                                                        p2.put(name.toLowerCase(), this.currentValue.toString().trim());
                                                        break block10;
                                                    }
                                                    if (!this.currentSet.equals("admin-agent")) break block15;
                                                    this.adminProps.setProperty(name.toLowerCase(), this.currentValue.toString().trim());
                                                    break block10;
                                                }
                                                if (!this.currentSet.equals("management-mode")) break block16;
                                                if (!this.currentValue.toString().toLowerCase().trim().equals("jmx")) break block10;
                                                this.jmxManagement = true;
                                                break block10;
                                            }
                                            if (!this.currentSet.equals("jndi_principal")) break block17;
                                            if (this.currentValue.toString().trim().length() <= 0) break block10;
                                            PoolManConfiguration.jndi_principal = this.currentValue.toString();
                                            break block10;
                                        }
                                        if (!this.currentSet.equals("jndi_credentials")) break block18;
                                        if (this.currentValue.toString().trim().length() <= 0) break block10;
                                        PoolManConfiguration.jndi_credentials = this.currentValue.toString();
                                        break block10;
                                    }
                                    if (!this.currentSet.equals("adaptor")) break block19;
                                    if (this.currentValue.toString().trim().length() <= 0) break block10;
                                    if (this.currentdbtype != null && !this.currentdbtype.equals("")) break block20;
                                    if (!log.isInfoEnabled()) break block10;
                                    log.info("ignoe adaptor[" + this.currentValue + "],\u6ca1\u6709\u6307\u5b9adbtype\u3002");
                                    break block10;
                                }
                                this.adaptors.put(this.currentdbtype, this.currentValue.toString().trim());
                                this.currentdbtype = null;
                                break block10;
                            }
                            if (!name.equals("needtableinfo")) break block21;
                            PoolManConfiguration.needtableinfo = this.currentValue.toString().trim().equals("true");
                            break block10;
                        }
                        if (!name.equals("refreshinterval")) break block22;
                        String refresh = this.currentValue.toString().trim();
                        try {
                            long temp2 = Long.parseLong(refresh);
                            PoolManConfiguration.setRefresh_interval(temp2);
                        }
                        catch (Exception e) {
                            if (!log.isInfoEnabled()) break block10;
                            log.info("refreshinterval:" + this.refreshinterval + "\u5fc5\u987b\u662flong\u503c", (Throwable)e);
                        }
                        break block10;
                    }
                    if (!name.equals("sqlMappingDir")) break block23;
                    String sqlMappingDir = this.currentValue.toString().trim();
                    if (sqlMappingDir.equals("")) break block10;
                    PoolManConfiguration.setSqlMappingDir(sqlMappingDir);
                    break block10;
                }
                if (!name.equals("columnNameMapping")) break block10;
                String columnNameMapping = this.currentValue.toString().trim();
                try {
                    if (!columnNameMapping.equals("")) {
                        boolean c = Boolean.parseBoolean(columnNameMapping);
                        PoolManConfiguration.setColumnNameMapping(c);
                    }
                    break block10;
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block10;
                    log.info("columnNameMapping:" + columnNameMapping + "\u5fc5\u987b\u662fboolean\u503c", (Throwable)e);
                }
                break block10;
            }
            for (int i = 0; i < n; ++i) {
                String _dbname = stringArray[i];
                if (!temp.equals(_dbname)) continue;
                if (this.filterpros == null) {
                    this.filterpros = new ArrayList<Properties>();
                }
                this.filterpros.add(p);
                break;
            }
        }
        this.currentValue.delete(0, this.currentValue.length());
    }

    public Map<String, String> getAdaptors() {
        return this.adaptors;
    }

    public void setAdaptors(Map<String, String> adaptors) {
        this.adaptors = adaptors;
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }
}

