/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.management.PoolManBootstrap;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PoolMan
implements Driver {
    public static String PROTOCOL = "jdbc:poolman:";
    public static final String XML_CONFIG_FILE = "poolman.xml";
    public static final String PROPS_CONFIG_FILE = "poolman.props";
    public static final int VERSIONID = 2;
    public static final int RELEASEID = 0;
    public static boolean STARTED = false;

    public static void main(String[] args) {
        if (null == args || args.length < 1) {
            System.out.println("\nUSAGE: java com.frameworkset.common.poolman.sql.PoolMan \"[db_name]\"\nWhere the [db_name] parameter corresponds to a dbname specified in your poolman.xml file.\n");
            System.exit(1);
        }
        System.out.print("Attempting to connect to " + args[0] + "... ");
        Connection con = null;
        try {
            Class.forName("com.frameworkset.common.poolman.sql.PoolMan").newInstance();
            con = DriverManager.getConnection("jdbc:poolman://" + args[0]);
            System.out.print("CONNECTED.\nTest passed, exiting.\n\n");
        }
        catch (Exception e) {
            System.out.print("FAILED.\nTest Failed with the following error:\n");
            e.printStackTrace();
            System.out.print("\n");
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
        System.exit(1);
    }

    public PoolMan() {
        this.registerDriver();
    }

    private void registerDriver() {
        boolean registered = false;
        try {
            Enumeration<Driver> enum1 = DriverManager.getDrivers();
            while (enum1.hasMoreElements()) {
                Driver d = enum1.nextElement();
                if (!(d instanceof PoolMan)) continue;
                registered = true;
            }
            if (!registered) {
                DriverManager.registerDriver(this);
            }
        }
        catch (SQLException se) {
            throw new RuntimeException("PoolMan Driver Failed to Load and Register with DriverManager");
        }
    }

    public static void start() throws Exception {
        if (!STARTED) {
            new PoolManBootstrap().start();
        }
    }

    public static DataSource getDataSource() throws SQLException {
        return PoolMan.findDataSource(null);
    }

    public static DataSource getDataSource(String dbname) throws SQLException {
        return PoolMan.findDataSource(dbname);
    }

    public static DataSource findDataSource() throws SQLException {
        return PoolMan.findDataSource(null);
    }

    public static DataSource findDataSource(String dbname) throws SQLException {
        SQLManager manager = SQLManager.getInstance();
        JDBCPool jpool = null;
        if (dbname == null) {
            jpool = manager.getPool(null);
        } else {
            try {
                jpool = manager.getPoolByJNDIName(dbname, true);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (jpool == null) {
                try {
                    jpool = manager.getPool(dbname);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        if (jpool == null) {
            throw new SQLException("No such datasource: " + dbname + ". Check your poolman.xml config, and be sure you are using a valid dbname parameter (use dbname, not jndiName)");
        }
        return jpool.getDataSource();
    }

    public static boolean nameIsValid(String dbname) {
        SQLManager manager = SQLManager.getInstance();
        for (String name : manager.getAllPoolNames()) {
            if (!dbname.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:poolman");
    }

    public static boolean acceptsURLString(String url) {
        return url.startsWith("jdbc:poolman");
    }

    /*
     * Loose catch block
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String dbname;
        SQLManager manager;
        block8: {
            if (!this.acceptsURL(url)) {
                return null;
            }
            manager = SQLManager.getInstance();
            dbname = null;
            if (url.indexOf("//") != -1) {
                dbname = url.substring(url.lastIndexOf("/") + 1, url.length());
            }
            if (null != info && info.containsKey("dbname")) {
                dbname = info.getProperty("dbname");
            }
            if (dbname != null && !dbname.equals("")) break block8;
            return manager.requestConnection();
            {
                catch (Exception pe) {
                    throw new SQLException(pe.getMessage());
                }
            }
        }
        try {
            return manager.requestConnection(dbname);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    public static Connection connect(String url) throws SQLException {
        String dbname;
        SQLManager manager;
        block7: {
            if (!PoolMan.acceptsURLString(url)) {
                return null;
            }
            manager = SQLManager.getInstance();
            dbname = null;
            if (url.indexOf("//") != -1) {
                dbname = url.substring(url.lastIndexOf("/") + 1, url.length());
            }
            if (dbname != null && !dbname.equals("")) break block7;
            return manager.requestConnection();
            {
                catch (Exception pe) {
                    throw new SQLException(pe.getMessage());
                }
            }
        }
        try {
            return manager.requestConnection(dbname);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

