/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.spi.assemble.BeanInstanceException;
import org.frameworkset.spi.ApplicationContextException;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.support.MessageSourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationObjectSupport {
    protected static final Logger logger = LoggerFactory.getLogger(ApplicationObjectSupport.class);
    private BaseApplicationContext applicationContext;
    private MessageSourceAccessor messageSourceAccessor;

    public final void setApplicationContext(BaseApplicationContext context) throws BeanInstanceException {
        if (context == null && !this.isContextRequired()) {
            this.applicationContext = null;
            this.messageSourceAccessor = null;
        } else if (this.applicationContext == null) {
            if (!this.requiredContextClass().isInstance(context)) {
                throw new ApplicationContextException("Invalid application context: needs to be of type [" + this.requiredContextClass().getName() + "]");
            }
            this.applicationContext = context;
            this.messageSourceAccessor = new MessageSourceAccessor(context);
            this.initApplicationContext(context);
        } else if (this.applicationContext != context) {
            throw new ApplicationContextException("Cannot reinitialize with different application context: current one is [" + this.applicationContext + "], passed-in one is [" + context + "]");
        }
    }

    protected boolean isContextRequired() {
        return false;
    }

    protected Class requiredContextClass() {
        return BaseApplicationContext.class;
    }

    protected void initApplicationContext(BaseApplicationContext context) throws RuntimeException {
        this.initApplicationContext();
    }

    protected void initApplicationContext() throws RuntimeException {
    }

    public final BaseApplicationContext getApplicationContext() throws IllegalStateException {
        if (this.applicationContext == null && this.isContextRequired()) {
            throw new IllegalStateException("ApplicationObjectSupport instance [" + this + "] does not run in an ApplicationContext");
        }
        return this.applicationContext;
    }

    protected final MessageSourceAccessor getMessageSourceAccessor() throws IllegalStateException {
        if (this.messageSourceAccessor == null && this.isContextRequired()) {
            throw new IllegalStateException("ApplicationObjectSupport instance [" + this + "] does not run in an ApplicationContext");
        }
        return this.messageSourceAccessor;
    }
}

