/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.batch.android.BatchAttributesFetchListener;
import com.batch.android.BatchBannerView;
import com.batch.android.BatchDataCollectionConfig;
import com.batch.android.BatchDeeplinkInterceptor;
import com.batch.android.BatchEventAttributes;
import com.batch.android.BatchEventDispatcher;
import com.batch.android.BatchInAppMessage;
import com.batch.android.BatchInboxFetcher;
import com.batch.android.BatchMessage;
import com.batch.android.BatchMessageAction;
import com.batch.android.BatchMessagingException;
import com.batch.android.BatchMigration;
import com.batch.android.BatchNotificationChannelsManager;
import com.batch.android.BatchNotificationInterceptor;
import com.batch.android.BatchOptOutResultListener;
import com.batch.android.BatchPermissionListener;
import com.batch.android.BatchProfileAttributeEditor;
import com.batch.android.BatchPushPayload;
import com.batch.android.BatchPushRegistration;
import com.batch.android.BatchTagCollectionsFetchListener;
import com.batch.android.LoggerDelegate;
import com.batch.android.LoggerLevel;
import com.batch.android.MessagingActivity;
import com.batch.android.PushNotificationType;
import com.batch.android.UserAction;
import com.batch.android.a1.e;
import com.batch.android.a1.g;
import com.batch.android.c.a;
import com.batch.android.debug.BatchDebugActivity;
import com.batch.android.e.p;
import com.batch.android.e.r;
import com.batch.android.e.u;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.batch.android.m.b0;
import com.batch.android.m.c0;
import com.batch.android.m.d;
import com.batch.android.m.d0;
import com.batch.android.m.f;
import com.batch.android.m.i;
import com.batch.android.m.n;
import com.batch.android.m.t;
import com.batch.android.m.v;
import com.batch.android.m.w;
import com.batch.android.m.x;
import com.batch.android.m0.k;
import com.batch.android.p.c;
import com.google.firebase.messaging.RemoteMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

@a
public final class Batch {
    @Nullable
    private static com.batch.android.f a;
    private static BroadcastReceiver b;
    private static Intent c;
    @NonNull
    private static final com.batch.android.e.k d;
    @Nullable
    private static String e;
    private static boolean f;
    public static final String NOTIFICATION_TAG = "batch";
    public static final String BROADCAST_PERMISSION_SUFFIX = ".batch.permission.INTERNAL_BROADCAST";
    public static final String ACTION_REGISTRATION_IDENTIFIER_OBTAINED = "com.batch.android.intent.action.push.REGISTRATION_IDENTIFIER_OBTAINED";
    public static final String EXTRA_REGISTRATION_IDENTIFIER = "registration_id";
    public static final String EXTRA_REGISTRATION_PROVIDER_NAME = "provider_name";
    public static final String EXTRA_REGISTRATION_SENDER_ID = "sender_id";
    @NonNull
    private static final com.batch.android.m0.b g;

    private Batch() {
    }

    public static void start(@NonNull String apiKey) {
        String string;
        x.a().b(b2 -> b2.a(string));
    }

    public static void disableMigration(@NonNull EnumSet<BatchMigration> migrations) {
        EnumSet<BatchMigration> enumSet;
        if (migrations == null) {
            r.a("You cannot use disableMigration with null value.");
            return;
        }
        x.a().b(b2 -> b2.a(BatchMigration.toValue(enumSet)));
    }

    public static void setLoggerDelegate(@Nullable LoggerDelegate delegate) {
        LoggerDelegate loggerDelegate;
        x.a().b(b2 -> b2.a(loggerDelegate));
    }

    public static void setLoggerLevel(@NonNull LoggerLevel level) {
        LoggerLevel loggerLevel;
        if (level == null) {
            r.a("You cannot setLoggerLevel with null value");
            return;
        }
        x.a().b(b2 -> b2.a(loggerLevel));
    }

    public static void updateAutomaticDataCollection(BatchDataCollectionConfig.Editor editor) {
        BatchDataCollectionConfig.Editor editor2;
        com.batch.android.m.f.a().a(editor2);
    }

    @Nullable
    public static String getSessionID() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        x.a().a(object -> {
            object = e;
            if (object != null) {
                stringBuilder2.append((String)((Object)object));
            }
        });
        if (stringBuilder.length() > 0) {
            return stringBuilder2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void copyBatchExtras(@Nullable Intent from, @Nullable Intent to) {
        void var1_1;
        com.batch.android.g.a(from, (Intent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyBatchExtras(@Nullable Bundle from, @Nullable Bundle to) {
        void var1_1;
        com.batch.android.g.a(from, (Bundle)var1_1);
    }

    @NonNull
    public static String getBroadcastPermissionName(@NonNull Context context) {
        Context context2;
        return context2.getPackageName() + BROADCAST_PERMISSION_SUFFIX;
    }

    public static void optOut(@NonNull Context context) {
        Batch.a(context, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void optOut(@NonNull Context context, @Nullable BatchOptOutResultListener listener) {
        void var1_1;
        Batch.a(context, false, (BatchOptOutResultListener)var1_1);
    }

    public static void optOutAndWipeData(@NonNull Context context) {
        Batch.a(context, true, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void optOutAndWipeData(@NonNull Context context, @Nullable BatchOptOutResultListener listener) {
        void var1_1;
        Batch.a(context, true, (BatchOptOutResultListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void a(@NonNull Context context, boolean wipeData, @Nullable BatchOptOutResultListener listener) {
        if (context != null) {
            void var2_2;
            void var1_1;
            Context context2;
            t.a().a(context2, (boolean)var1_1, (BatchOptOutResultListener)var2_2).a(value -> {
                e e2 = x.a();
                e2.m();
                Activity activity = e2.b();
                if (activity == null) {
                    Context context2;
                    activity = context2.getApplicationContext();
                }
                Batch.b((Context)activity, false, true);
            }).a(arg_0 -> Batch.a((BatchOptOutResultListener)var2_2, arg_0));
            return;
        }
        throw new IllegalArgumentException("Context can't be null");
    }

    public static void optIn(@NonNull Context context) {
        if (context != null) {
            Context context2;
            t.a().d(context2);
            return;
        }
        throw new IllegalArgumentException("Context can't be null");
    }

    public static boolean isOptedOut(@NonNull Context context) {
        if (context != null) {
            Context context2;
            return t.a().c(context2);
        }
        throw new IllegalArgumentException("Context can't be null");
    }

    public static void setFindMyInstallationEnabled(boolean enabled) {
        com.batch.android.i.a.e = enabled;
    }

    public static void onCreate(Activity activity) {
        Activity activity2;
        if (activity == null) {
            return;
        }
        if (com.batch.android.e.k.a(activity2)) {
            d.b(activity2);
            r.c("Created activity has exclusion meta-data");
        }
    }

    public static void onStart(Activity activity) {
        Batch.a((Context)activity, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void onServiceCreate(Context context, boolean userActivity) {
        void var1_1;
        Batch.a(context, true, (boolean)var1_1);
    }

    public static void onServiceDestroy(Context context) {
        Batch.b(context, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void onNewIntent(Activity activity, Intent intent) {
        void var1_1;
        c = var1_1;
        Batch.a((Context)activity, false, true);
    }

    public static void onStop(Activity activity) {
        Batch.b((Context)activity, false, false);
    }

    public static void onDestroy(Activity activity) {
        Batch.b((Context)activity, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Context context, boolean bumpRetainCount, boolean userActivity) {
        boolean bl;
        Context context2;
        void var2_3;
        StringBuilder stringBuilder;
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        e e2 = x.a();
        bl = x.a().a((arg_0, arg_1) -> Batch.a(e2, (boolean)var2_3, context2, bl, atomicBoolean2, stringBuilder2, arg_0, arg_1));
        if (bl) {
            g.b();
        }
        if (bl) {
            e e3 = e2;
            Object object = com.batch.android.a1.g.b;
            e3.a((g)((Object)object), arg_0 -> Batch.a(e3, atomicBoolean2, stringBuilder2, (boolean)var2_3, arg_0));
            e3.a(b2 -> {
                if (b2.b() != null && b2.b().toLowerCase(Locale.US).startsWith("dev")) {
                    r.e("Batch (2.1.1) is running in dev mode (your API key is a dev one)");
                }
            });
            object = User.getInstallationID();
            if (object != null) {
                r.b("Installation ID: " + (String)object);
            }
            if (k.d(context2)) {
                r.b("The app is running in restricted backgrounding mode");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void b(Context _context, boolean fromService, boolean force) {
        void var2_2;
        void var1_1;
        Object object;
        Context context = object;
        object = com.batch.android.a1.g.b;
        if (x.a().a((g)((Object)object), (arg_0, arg_1) -> Batch.a((boolean)var1_1, context, (boolean)var2_2, arg_0, arg_1))) {
            if (!b0.a(x.a().c()).a()) {
                r.c("onStop, should stop directly : true");
                Batch.e();
            } else {
                r.c("onStop, should stop directly : false");
            }
        }
    }

    private static void g() {
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        g g3 = com.batch.android.a1.g.c;
        x.a().a(g3, g2 -> atomicBoolean2.set(true));
        r.c("onWebserviceExecutorWorkFinished called, should stop " + atomicBoolean2);
        if (atomicBoolean.get()) {
            Batch.e();
        }
    }

    private static void e() {
        if (x.a().a(com.batch.android.a1.g.c, (g2, b2) -> {
            r.c("doStop, called with state " + (Object)((Object)g2));
            g.f();
            c0.a().a("_STOP");
            x.a().a((Context)null);
            b = null;
            return com.batch.android.a1.g.a;
        })) {
            g.c();
        }
    }

    private static void d() {
        r.c("OptOut", "Clearing cached install data");
        a = null;
    }

    @Nullable
    static com.batch.android.f f() {
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void h() {
        Exception exception2;
        block4: {
            String string;
            String string2;
            block3: {
                try {
                    string2 = "2.1.1";
                    string = com.batch.android.m.u.a(x.a().c()).a("app.version.current");
                    if (string != null) break block3;
                }
                catch (Exception exception2) {
                    break block4;
                }
                com.batch.android.m.u.a(x.a().c()).a("app.version.current", string2, true);
                return;
            }
            if (string.equals(string2)) return;
            com.batch.android.m.u.a(x.a().c()).a("app.version.current", string2, true);
            com.batch.android.m.u.a(x.a().c()).a("app.version.previous", string, true);
            return;
        }
        r.c("Error on updateVersionManagement", exception2);
    }

    private static /* synthetic */ g a(boolean bl, Context context, boolean bl2, g g2, com.batch.android.a1.b b2) {
        r.c("onStop called with state " + (Object)((Object)g2));
        if (bl) {
            x.a().a();
        }
        g2 = x.a().b();
        b2 = null;
        if (context instanceof Activity) {
            b2 = (Activity)context;
        }
        if (b2 != null) {
            if (com.batch.android.e.k.a((Activity)b2)) {
                r.c("Closing an excluded activity");
                return null;
            }
            if (b2 != g2) {
                r.c("Closing a sub activity");
                return null;
            }
        }
        if (!(bl || bl2 || g2 == null || g2.isFinishing())) {
            r.c("onStop called but activity is not finishing... saving date");
            x.a().l();
            return null;
        }
        if (!bl) {
            x.a().a((Activity)null);
        }
        if (x.a().b() == null && !x.a().j()) {
            g.d();
            return com.batch.android.a1.g.c;
        }
        r.c("onStop called, but Batch is retained by a Service or Activity");
        return null;
    }

    private static /* synthetic */ void a(e e2, AtomicBoolean atomicBoolean, StringBuilder stringBuilder, boolean bl, g g2) {
        boolean bl2 = atomicBoolean.get();
        com.batch.android.a.n.a(e2, bl2, stringBuilder.toString(), bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ g a(e object, boolean bl, Context context, boolean bl2, AtomicBoolean atomicBoolean, StringBuilder object2, g g2, com.batch.android.a1.b b2) {
        block53: {
            void var0_4;
            block54: {
                block52: {
                    c c2;
                    Object object3;
                    JSONException jSONException2;
                    JSONObject jSONObject;
                    Object object4;
                    block51: {
                        JSONObject jSONObject2;
                        boolean bl3;
                        block55: {
                            Object object5;
                            block50: {
                                com.batch.android.g g3;
                                ArrayList<Object> arrayList;
                                boolean bl4;
                                Object object6;
                                block47: {
                                    Exception exception2;
                                    block49: {
                                        block48: {
                                            if (b2 == null) {
                                                r.a("You must set the configuration before starting Batch. Please call setConfig on onCreate of your Application subclass");
                                                return null;
                                            }
                                            Object object7 = object;
                                            Long l2 = ((e)object7).k();
                                            bl3 = true;
                                            object6 = ((e)object7).d();
                                            if (!(bl && object6 == null || (l2 == null || l2 <= new Date().getTime() - 30000L) && (l2 != null || g2 != com.batch.android.a1.g.b || object6 != null && ((Date)object6).getTime() <= new Date().getTime() - 82800000L))) {
                                                bl3 = false;
                                            }
                                            if (l2 != null && bl3) {
                                                long l3 = l2;
                                                c0.a().a("_STOP", l3);
                                            }
                                            r.c("onStart called on state " + (Object)((Object)g2) + ", should start : " + bl3);
                                            if (context == null) {
                                                r.a("Batch start called with null context, aborting start");
                                                return null;
                                            }
                                            if (t.a().c(context)) {
                                                if (f) return null;
                                                f = true;
                                                r.a("Batch was opted out from: refusing to start.");
                                                return null;
                                            }
                                            if (bl2) {
                                                ((e)object).g();
                                            }
                                            object4 = null;
                                            if (!(context instanceof Activity)) break block55;
                                            object4 = (Activity)context;
                                            if (com.batch.android.e.k.a((Activity)object4)) {
                                                r.c("Started activity has exclusion meta-data, aborting start.");
                                                return null;
                                            }
                                            bl4 = true;
                                            try {
                                                if (g2 == com.batch.android.a1.g.a || ((e)object).b() == null) break block47;
                                                if (object4.getWindow().isFloating() || object4 instanceof MessagingActivity) break block48;
                                                object6 = object4.getTheme().obtainStyledAttributes(new int[]{16842840});
                                            }
                                            catch (Exception exception2) {
                                                break block49;
                                            }
                                            bl4 = !object6.getBoolean(0, false);
                                            object6.recycle();
                                        }
                                        bl4 = false;
                                        break block47;
                                    }
                                    r.c("Error while trying to check if the current activity is transparent/floating. Reverting to default behaviour.", exception2);
                                }
                                if (bl4) {
                                    ((e)object).a((Activity)object4);
                                }
                                object5 = arrayList;
                                arrayList = new ArrayList<Object>();
                                object6 = g3;
                                g3 = new com.batch.android.g((Activity)object4);
                                if (c != null) {
                                    r.c("Adding intent from onNewIntent");
                                    object5.add(new com.batch.android.g(c));
                                }
                                object5.add(object6);
                                object4 = d;
                                if (((com.batch.android.e.k)object4).a()) {
                                    r.c("Adding intent from an activity with exclusion meta-data");
                                    object5.add(new com.batch.android.g(((com.batch.android.e.k)object4).b()));
                                }
                                object4 = object5.iterator();
                                while (object4.hasNext()) {
                                    object5 = (com.batch.android.g)object4.next();
                                    if (!((com.batch.android.g)object5).g()) continue;
                                    object4 = object5;
                                    break block50;
                                }
                                object4 = object6;
                            }
                            if (((com.batch.android.g)object4).g()) {
                                r.c("Activity has a push payload");
                            } else {
                                r.c("Activity does not have a push payload");
                            }
                            AtomicBoolean atomicBoolean2 = atomicBoolean;
                            atomicBoolean2.set(((com.batch.android.g)object4).a());
                            if (atomicBoolean2.get()) {
                                bl3 = true;
                                object5 = ((com.batch.android.g)object4).e();
                                if (object5 != null) {
                                    ((StringBuilder)object2).append((String)object5);
                                }
                            }
                            if (com.batch.android.m.r.a().l() && ((com.batch.android.g)object4).f()) {
                                if (((com.batch.android.g)object4).h()) {
                                    r.c("Trying to display an already shown landing message");
                                } else {
                                    object2 = ((com.batch.android.g)object4).b();
                                    if (object2 != null) {
                                        ((com.batch.android.g)object4).j();
                                        com.batch.android.m.r.a().a(context, (BatchMessage)object2, false);
                                    }
                                }
                            }
                            u.b(context);
                            c = null;
                        }
                        if (g2 == com.batch.android.a1.g.b && !bl3) {
                            return null;
                        }
                        object2 = context.getApplicationContext();
                        if (g2 == com.batch.android.a1.g.a) {
                            ((e)object).a((Context)object2);
                            n.a((Context)object2);
                            g.a((Context)object2);
                            Batch.h();
                            if (!com.batch.android.e.n.a("android.permission.INTERNET", (Context)object2)) {
                                r.a("Batch needs android.permission.INTERNET, please update your manifest, aborting start");
                                return null;
                            }
                            if (b2.b() == null) {
                                r.a("API key provided in Batch.start is null, aborting start");
                                return null;
                            }
                            if (a == null) {
                                a = new com.batch.android.f((Context)object2);
                            }
                            e = UUID.randomUUID().toString();
                            if (b == null) {
                                IntentFilter intentFilter;
                                b = new b();
                                g2 = intentFilter;
                                new IntentFilter().addAction("com.batch.android.executor.finished");
                                g2.addAction("com.batch.android.optout.enabled");
                                n.a((Context)object2).a(b, (IntentFilter)g2);
                            }
                            t.a().e(context);
                        }
                        if (object2 instanceof Application) {
                            Object object8 = object;
                            object2 = (Application)object2;
                            ((e)object8).a((Application)object2, true);
                            ((e)object8).a((Application)object2);
                        } else {
                            r.a("Context isn't an Application, could not register the session manager.");
                        }
                        g.e();
                        i.a().b(context);
                        jSONObject = jSONObject2;
                        try {
                            jSONObject2 = new JSONObject();
                            if (bl) {
                                ((e)object).n();
                                break block51;
                            }
                            jSONObject.put("silent", true);
                        }
                        catch (JSONException jSONException2) {}
                    }
                    JSONObject jSONObject3 = jSONObject;
                    JSONObject jSONObject4 = jSONObject3;
                    jSONObject3.putOpt("dispatchers", i.a().i());
                    if (jSONObject4.length() == 0) {
                        jSONObject = null;
                    }
                    c0.a().a("_START", jSONObject);
                    r.c("Could not track _START", jSONException2);
                    if (object4 == null) return com.batch.android.a1.g.b;
                    if (!atomicBoolean.get()) return com.batch.android.a1.g.b;
                    if (((com.batch.android.g)object4).i()) {
                        r.c("Already tracked open");
                        return com.batch.android.a1.g.b;
                    }
                    object = ((com.batch.android.g)object4).d();
                    if (object != null) {
                        JSONObject jSONObject5;
                        object3 = jSONObject5;
                        jSONObject5 = new JSONObject(((p)object).g());
                    } else {
                        JSONObject jSONObject6;
                        object3 = jSONObject6;
                        jSONObject6 = new JSONObject();
                    }
                    Object object9 = object4;
                    c0.a().a("_OPEN_PUSH", (JSONObject)object3);
                    ((com.batch.android.g)object9).k();
                    object = ((com.batch.android.g)object9).c();
                    if (object == null) break block52;
                    object = BatchPushPayload.payloadFromReceiverExtras((Bundle)object);
                    object3 = c2;
                    try {
                        c2 = new c((BatchPushPayload)object, true);
                        i.a().a(EventDispatcher.Type.NOTIFICATION_OPEN, (EventDispatcher.Payload)object3);
                        break block53;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break block54;
                    }
                    catch (BatchPushPayload.ParsingException parsingException) {
                        break block54;
                    }
                }
                r.c("Could not get the push bundle.");
                break block53;
            }
            r.c("Could not dispatch NOTIFICATION_OPEN", (Throwable)var0_4);
        }
        r.b("Activity was opened from a push");
        return com.batch.android.a1.g.b;
    }

    private static /* synthetic */ void a(BatchOptOutResultListener listener, Exception e2) {
        if (listener != null) {
            BatchOptOutResultListener batchOptOutResultListener;
            batchOptOutResultListener.onError();
        }
    }

    static {
        d = new com.batch.android.e.k();
        f = false;
        g = com.batch.android.m.c.a();
    }

    @a
    public static final class User {
        private User() {
        }

        @Nullable
        public static String getInstallationID() {
            com.batch.android.f f2 = a;
            if (f2 != null) {
                return f2.b();
            }
            return null;
        }

        @Nullable
        public static String getLanguage(@NonNull Context context) {
            if (context != null) {
                Context context2;
                return d0.a().c(context2);
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        @Nullable
        public static String getRegion(@NonNull Context context) {
            if (context != null) {
                Context context2;
                return d0.a().d(context2);
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        @Nullable
        public static String getIdentifier(@NonNull Context context) {
            if (context != null) {
                Context context2;
                return d0.a().b(context2);
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        public static void fetchAttributes(@NonNull Context context, @Nullable BatchAttributesFetchListener listener) {
            void var1_1;
            com.batch.android.k.a(context, (BatchAttributesFetchListener)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        public static void fetchTagCollections(@NonNull Context context, @Nullable BatchTagCollectionsFetchListener listener) {
            void var1_1;
            com.batch.android.k.a(context, (BatchTagCollectionsFetchListener)var1_1, true);
        }

        public static void clearInstallationData() {
            d0.a().i();
        }
    }

    private static class b
    extends BroadcastReceiver {
        private b() {
        }

        /*
         * WARNING - void declaration
         */
        public void onReceive(Context context, Intent intent) {
            void var2_2;
            if (intent == null) {
                return;
            }
            String string = var2_2.getAction();
            if (string == null) {
                return;
            }
            if (!string.equals("com.batch.android.executor.finished")) {
                if (string.equals("com.batch.android.optout.enabled")) {
                    Batch.d();
                }
            } else {
                Batch.g();
            }
        }
    }

    @a
    public static final class EventDispatcher {
        private EventDispatcher() {
        }

        public static void addDispatcher(BatchEventDispatcher dispatcher) {
            BatchEventDispatcher batchEventDispatcher;
            i.a().a(batchEventDispatcher);
        }

        public static boolean removeDispatcher(BatchEventDispatcher dispatcher) {
            BatchEventDispatcher batchEventDispatcher;
            return i.a().b(batchEventDispatcher);
        }

        @a
        public static interface Payload {
            @Nullable
            public String getTrackingId();

            @Nullable
            public String getWebViewAnalyticsID();

            @Nullable
            public String getDeeplink();

            public boolean isPositiveAction();

            @Nullable
            public String getCustomValue(@NonNull String var1);

            @Nullable
            public BatchMessage getMessagingPayload();

            @Nullable
            public BatchPushPayload getPushPayload();
        }

        @a
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type NOTIFICATION_DISPLAY = new Type();
            public static final /* enum */ Type NOTIFICATION_DISMISS = new Type();
            public static final /* enum */ Type NOTIFICATION_OPEN = new Type();
            public static final /* enum */ Type MESSAGING_SHOW = new Type();
            public static final /* enum */ Type MESSAGING_CLOSE = new Type();
            public static final /* enum */ Type MESSAGING_AUTO_CLOSE = new Type();
            public static final /* enum */ Type MESSAGING_CLOSE_ERROR = new Type();
            public static final /* enum */ Type MESSAGING_CLICK = new Type();
            public static final /* enum */ Type MESSAGING_WEBVIEW_CLICK = new Type();
            private static final /* synthetic */ Type[] a;

            public static Type[] values() {
                return (Type[])a.clone();
            }

            public static Type valueOf(String name) {
                String string;
                return Enum.valueOf(Type.class, string);
            }

            private static /* synthetic */ Type[] a() {
                return new Type[]{NOTIFICATION_DISPLAY, NOTIFICATION_DISMISS, NOTIFICATION_OPEN, MESSAGING_SHOW, MESSAGING_CLOSE, MESSAGING_AUTO_CLOSE, MESSAGING_CLOSE_ERROR, MESSAGING_CLICK, MESSAGING_WEBVIEW_CLICK};
            }

            static {
                a = Type.a();
            }

            public boolean isNotificationEvent() {
                return this == NOTIFICATION_OPEN || this == NOTIFICATION_DISPLAY || this == NOTIFICATION_DISMISS;
            }

            public boolean isMessagingEvent() {
                return this.isNotificationEvent() ^ true;
            }
        }
    }

    @a
    public static final class Actions {
        private Actions() {
        }

        public static void register(@NonNull UserAction userAction) {
            UserAction userAction2;
            com.batch.android.m.a.a().a(userAction2);
        }

        public static void unregister(@NonNull String identifier) {
            String string;
            com.batch.android.m.a.a().b(string);
        }

        /*
         * WARNING - void declaration
         */
        public static void addDrawableAlias(@NonNull String alias, @DrawableRes int drawableID) {
            void var1_1;
            String string;
            com.batch.android.m.a.a().a(string, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean performAction(@NonNull Context context, @NonNull String actionIdentifier, @Nullable JSONObject arguments) {
            void var2_2;
            void var1_1;
            Context context2;
            return com.batch.android.m.a.a().a(context2, (String)var1_1, (JSONObject)var2_2);
        }

        public static void setDeeplinkInterceptor(@Nullable BatchDeeplinkInterceptor interceptor) {
            BatchDeeplinkInterceptor batchDeeplinkInterceptor;
            com.batch.android.m.a.a().a(batchDeeplinkInterceptor);
        }
    }

    @com.batch.android.c.a
    public static final class Messaging {
        public static final int GLOBAL_TAP_ACTION_INDEX = -1;

        private Messaging() {
        }

        public static void setShowForegroundLandings(boolean showForegroundLandings) {
            boolean bl;
            com.batch.android.m.r.a().d(bl);
        }

        public static void setAutomaticMode(boolean automatic) {
            boolean bl;
            com.batch.android.m.r.a().b(bl);
        }

        /*
         * WARNING - void declaration
         */
        public static void setTypefaceOverride(@Nullable Typeface normalTypeface, @Nullable Typeface boldTypeface) {
            void var1_1;
            Typeface typeface;
            com.batch.android.m.r.a().a(typeface, (Typeface)var1_1);
        }

        public static void setLifecycleListener(@Nullable LifecycleListener listener) {
            LifecycleListener lifecycleListener;
            com.batch.android.m.r.a().a(lifecycleListener);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static DialogFragment loadFragment(@NonNull Context context, @NonNull BatchMessage message) throws BatchMessagingException {
            void var1_1;
            Context context2;
            return com.batch.android.m.r.a().b(context2, (BatchMessage)var1_1, var1_1.c());
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static BatchBannerView loadBanner(@NonNull Context context, @NonNull BatchMessage message) throws BatchMessagingException {
            void var1_1;
            Context context2;
            return com.batch.android.m.r.a().a(context2, (BatchMessage)var1_1, var1_1.c());
        }

        /*
         * WARNING - void declaration
         */
        public static void show(@NonNull Context context, @NonNull BatchMessage message) {
            if (context != null) {
                void var1_1;
                if (var1_1 != null) {
                    Context context2;
                    com.batch.android.m.r.a().a(context2, (BatchMessage)var1_1, true);
                    return;
                }
                throw new IllegalArgumentException("message can't be null");
            }
            throw new IllegalArgumentException("context can't be null");
        }

        public static void setDoNotDisturbEnabled(boolean enableDnd) {
            boolean bl;
            com.batch.android.m.r.a().c(bl);
        }

        public static boolean isDoNotDisturbEnabled() {
            return com.batch.android.m.r.a().k();
        }

        public static boolean hasPendingMessage() {
            return com.batch.android.m.r.a().j();
        }

        @Nullable
        public static BatchMessage popPendingMessage() {
            return com.batch.android.m.r.a().m();
        }

        @com.batch.android.c.a
        public static interface LifecycleListener {
            public void onBatchMessageShown(@Nullable String var1);

            public void onBatchMessageClosed(@Nullable String var1);

            default public void onBatchMessageActionTriggered(@Nullable String messageIdentifier, int index, @NonNull BatchMessageAction action) {
            }

            default public void onBatchMessageWebViewActionTriggered(@Nullable String messageIdentifier, @Nullable String analyticsID, @Nullable BatchMessageAction action) {
            }

            default public void onBatchMessageCancelledByUser(@Nullable String messageIdentifier) {
            }

            default public void onBatchMessageCancelledByAutoclose(@Nullable String messageIdentifier) {
            }

            default public void onBatchMessageCancelledByError(@Nullable String messageIdentifier) {
            }
        }

        @com.batch.android.c.a
        public static class DisplayHint {
            a a;
            View b;

            /*
             * WARNING - void declaration
             */
            private DisplayHint(@NonNull View view, @NonNull a strategy) {
                void var1_1;
                void var2_2;
                this.a = var2_2;
                this.b = var1_1;
            }

            public static DisplayHint findUsingView(@NonNull View view) {
                if (view != null) {
                    View view2;
                    return new DisplayHint(view2, com.batch.android.Batch$Messaging$a.a);
                }
                throw new IllegalArgumentException("view cannot be null");
            }

            public static DisplayHint embed(@NonNull FrameLayout layout) {
                if (layout != null) {
                    FrameLayout frameLayout;
                    return new DisplayHint((View)frameLayout, com.batch.android.Batch$Messaging$a.b);
                }
                throw new IllegalArgumentException("layout cannot be null");
            }
        }

        @com.batch.android.c.a
        public static interface DisplayHintProvider {
            public DisplayHint getBatchMessageDisplayHint(BatchMessage var1);
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a a = new a();
            public static final /* enum */ a b = new a();
            private static final /* synthetic */ a[] c;

            public static a[] values() {
                return (a[])c.clone();
            }

            public static a valueOf(String name) {
                String string;
                return Enum.valueOf(a.class, string);
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b};
            }

            static {
                c = com.batch.android.Batch$Messaging$a.a();
            }
        }

        @com.batch.android.c.a
        public static interface LifecycleListener2
        extends LifecycleListener {
            public boolean onBatchInAppMessageReady(@NonNull BatchInAppMessage var1);
        }
    }

    @a
    public static final class Profile {
        private Profile() {
        }

        public static void identify(@Nullable String identifier) {
            String string;
            v.a().a(string);
        }

        @NonNull
        public static BatchProfileAttributeEditor editor() {
            return new BatchProfileAttributeEditor();
        }

        public static void trackEvent(@NonNull String event) {
            String string;
            v.a().a(string, (BatchEventAttributes)null);
        }

        /*
         * WARNING - void declaration
         */
        public static void trackEvent(@NonNull String event, @Nullable BatchEventAttributes attributes) {
            void var1_1;
            String string;
            v.a().a(string, (BatchEventAttributes)var1_1);
        }

        public static void trackLocation(@NonNull Location location) {
            Location location2;
            d0.a().a(location2);
        }
    }

    @a
    public static final class Push {
        public static final String BODY_KEY = "msg";
        public static final String ALERT_KEY = "msg";
        public static final String TITLE_KEY = "title";
        public static final String PAYLOAD_KEY = "batchPushPayload";

        private Push() {
        }

        public static void setSmallIconResourceId(@DrawableRes int resourceId) {
            int n2;
            w.a().a(n2);
        }

        public static void setSound(Uri uri) {
            Uri uri2;
            w.a().a(uri2);
        }

        public static void setLargeIcon(Bitmap largeIcon) {
            Bitmap bitmap;
            w.a().a(bitmap);
        }

        @NonNull
        public static BatchNotificationChannelsManager getChannelsManager() {
            return com.batch.android.m.d.a();
        }

        public static void dismissNotifications() {
            w.a().i();
        }

        @Nullable
        public static EnumSet<PushNotificationType> getNotificationsType(Context context) {
            Context context2;
            return w.a().b(context2);
        }

        public static void setNotificationsType(EnumSet<PushNotificationType> types) {
            EnumSet<PushNotificationType> enumSet;
            w.a().a(enumSet);
        }

        public static boolean isBatchPush(Intent intent) {
            Intent intent2;
            return w.a().a(intent2);
        }

        public static boolean isBatchPush(RemoteMessage message) {
            RemoteMessage remoteMessage;
            return w.a().a(remoteMessage);
        }

        public static void setNotificationsColor(@ColorInt int argbColor) {
            int n2;
            w.a().b(n2);
        }

        public static boolean isManualDisplayModeActivated() {
            return w.a().t();
        }

        public static void setManualDisplay(boolean manualDisplay) {
            boolean bl;
            w.a().a(bl);
        }

        /*
         * WARNING - void declaration
         */
        public static void appendBatchData(Intent pushIntent, Intent openIntent) {
            void var1_1;
            Intent intent;
            w.a().a(intent, (Intent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static void appendBatchData(@NonNull Bundle pushIntentExtras, @NonNull Intent openIntent) {
            void var1_1;
            Bundle bundle;
            w.a().a(bundle, (Intent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static void appendBatchData(@NonNull RemoteMessage remoteMessage, @NonNull Intent openIntent) {
            void var1_1;
            RemoteMessage remoteMessage2;
            w.a().a(remoteMessage2, (Intent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static PendingIntent makePendingIntent(@NonNull Context context, @NonNull Intent intent, @NonNull Bundle pushIntentExtras) {
            if (context != null) {
                void var1_1;
                if (var1_1 != null) {
                    void var2_2;
                    if (var2_2 != null) {
                        Context context2;
                        return w.a().a(context2, (Intent)var1_1, (Bundle)var2_2);
                    }
                    throw new IllegalArgumentException("PushIntentExtras cannot be null");
                }
                throw new IllegalArgumentException("Intent cannot be null");
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static PendingIntent makePendingIntent(@NonNull Context context, @NonNull Intent intent, @NonNull RemoteMessage remoteMessage) {
            if (context != null) {
                void var1_1;
                if (var1_1 != null) {
                    void var2_2;
                    if (var2_2 != null) {
                        Context context2;
                        return w.a().a(context2, (Intent)var1_1, (RemoteMessage)var2_2);
                    }
                    throw new IllegalArgumentException("RemoteMessage cannot be null");
                }
                throw new IllegalArgumentException("Intent cannot be null");
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public static PendingIntent makePendingIntentForDeeplink(@NonNull Context context, @NonNull String deeplink, @NonNull Bundle pushIntentExtras) {
            if (context != null) {
                void var1_1;
                if (var1_1 != null) {
                    void var2_2;
                    if (var2_2 != null) {
                        Context context2;
                        return w.a().a(context2, (String)var1_1, (Bundle)var2_2);
                    }
                    throw new IllegalArgumentException("PushIntentExtras cannot be null");
                }
                throw new IllegalArgumentException("Deeplink cannot be null");
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public static PendingIntent makePendingIntentForDeeplink(@NonNull Context context, @NonNull String deeplink, @NonNull RemoteMessage remoteMessage) {
            if (context != null) {
                void var1_1;
                if (var1_1 != null) {
                    void var2_2;
                    if (var2_2 != null) {
                        Context context2;
                        return w.a().a(context2, (String)var1_1, (RemoteMessage)var2_2);
                    }
                    throw new IllegalArgumentException("RemoteMessage cannot be null");
                }
                throw new IllegalArgumentException("Deeplink cannot be null");
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        public static boolean shouldDisplayPush(Context context, Intent intent) {
            void var1_1;
            Context context2;
            return w.a().b(context2, (Intent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean shouldDisplayPush(Context context, RemoteMessage remoteMessage) {
            void var1_1;
            Context context2;
            return w.a().b(context2, (RemoteMessage)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(Context context, Intent intent) {
            void var1_1;
            Context context2;
            w.a().a(context2, (Intent)var1_1, null, false);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(Context context, Intent intent, boolean bypassManualMode) {
            void var2_2;
            void var1_1;
            Context context2;
            w.a().a(context2, (Intent)var1_1, null, (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(@NonNull Context context, @NonNull Intent intent, @Nullable BatchNotificationInterceptor interceptor) {
            void var2_2;
            void var1_1;
            Context context2;
            w.a().a(context2, (Intent)var1_1, (BatchNotificationInterceptor)var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(@NonNull Context context, @NonNull Intent intent, @Nullable BatchNotificationInterceptor interceptor, boolean bypassManualMode) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            w.a().a(context2, (Intent)var1_1, (BatchNotificationInterceptor)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(Context context, RemoteMessage remoteMessage) {
            void var1_1;
            Context context2;
            w.a().a(context2, (RemoteMessage)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public static void displayNotification(@NonNull Context context, @NonNull RemoteMessage remoteMessage, @Nullable BatchNotificationInterceptor interceptor) {
            void var2_2;
            void var1_1;
            Context context2;
            w.a().a(context2, (RemoteMessage)var1_1, (BatchNotificationInterceptor)var2_2);
        }

        public static void setAdditionalIntentFlags(Integer flags) {
            Integer n2;
            w.a().a(n2);
        }

        /*
         * WARNING - void declaration
         */
        public static void onNotificationDisplayed(Context context, Intent intent) {
            void var1_1;
            Context context2;
            w.a().a(context2, (Intent)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static void onNotificationDisplayed(Context context, RemoteMessage remoteMessage) {
            void var1_1;
            Context context2;
            w.a().a(context2, (RemoteMessage)var1_1);
        }

        @Nullable
        public static BatchPushRegistration getRegistration() {
            return w.a().p();
        }

        public static void setNotificationInterceptor(@Nullable BatchNotificationInterceptor interceptor) {
            BatchNotificationInterceptor batchNotificationInterceptor;
            w.a().a(batchNotificationInterceptor);
        }

        public static void refreshRegistration() {
            w.a().v();
        }

        public static void requestNotificationPermission(@NonNull Context context) {
            Context context2;
            w.a().a(context2, (BatchPermissionListener)null);
        }

        /*
         * WARNING - void declaration
         */
        public static void requestNotificationPermission(@NonNull Context context, @Nullable BatchPermissionListener listener) {
            void var1_1;
            Context context2;
            w.a().a(context2, (BatchPermissionListener)var1_1);
        }
    }

    @a
    public static final class Inbox {
        private Inbox() {
        }

        @NonNull
        public static BatchInboxFetcher getFetcher(@NonNull Context context) {
            if (context != null) {
                Context context2;
                String string = new com.batch.android.f(context2).b();
                return new BatchInboxFetcher(com.batch.android.m.k.a(context2, string));
            }
            throw new IllegalArgumentException("Context cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static BatchInboxFetcher getFetcher(@NonNull Context context, @NonNull String userIdentifier, @NonNull String authenticationKey) {
            if (context != null) {
                void var2_2;
                void var1_1;
                Context context2;
                return new BatchInboxFetcher(com.batch.android.m.k.a(context2, (String)var1_1, (String)var2_2));
            }
            throw new IllegalArgumentException("Context cannot be null");
        }
    }

    @a
    public static final class Debug {
        private Debug() {
        }

        public static void startDebugActivity(@NonNull Context context) {
            Context context2;
            Intent intent;
            Intent intent2 = intent;
            intent = new Intent(context2, BatchDebugActivity.class);
            context.startActivity(intent2);
        }
    }
}

