/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.msgpack.core.buffer;

import com.batch.android.msgpack.core.buffer.f;
import com.batch.android.p0.b.p;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final boolean isUniversalBuffer;
    static final Unsafe unsafe;
    static final int javaVersion;
    private static final Constructor<?> mbArrConstructor;
    private static final Constructor<?> mbBBConstructor;
    static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String UNIVERSAL_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBufferU";
    private static final String BIGENDIAN_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBufferBE";
    private static final String DEFAULT_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBuffer";
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    private static int getJavaVersion() {
        String string2 = System.getProperty("java.specification.version", "");
        int n2 = string2.indexOf(46);
        if (n2 != -1) {
            int n3 = Integer.parseInt(string2.substring(0, n2));
            try {
                int n4 = Integer.parseInt(string2.substring(n2 + 1));
                if (n3 > 1) {
                    n4 = n3;
                }
                return n4;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        } else {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
        return 6;
    }

    public static MessageBuffer allocate(int size) {
        if (size >= 0) {
            int n2;
            return MessageBuffer.wrap(new byte[n2]);
        }
        throw new IllegalArgumentException("size must not be negative");
    }

    public static MessageBuffer wrap(byte[] array) {
        return MessageBuffer.newMessageBuffer(array, 0, array.length);
    }

    /*
     * WARNING - void declaration
     */
    public static MessageBuffer wrap(byte[] array, int offset, int length) {
        void var2_2;
        void var1_1;
        return MessageBuffer.newMessageBuffer(array, (int)var1_1, (int)var2_2);
    }

    public static MessageBuffer wrap(ByteBuffer bb) {
        return MessageBuffer.newMessageBuffer(bb);
    }

    /*
     * WARNING - void declaration
     */
    private static MessageBuffer newMessageBuffer(byte[] arr, int off, int len) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        p.a(arr);
        Object[] objectArray = mbArrConstructor;
        if (mbArrConstructor != null) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[3];
            objectArray = objectArray3;
            objectArray[0] = byArray;
            objectArray[1] = (int)var1_1;
            objectArray3[2] = (int)var2_2;
            return MessageBuffer.newInstance(objectArray2, objectArray3);
        }
        return new MessageBuffer(byArray, (int)var1_1, (int)var2_2);
    }

    private static MessageBuffer newMessageBuffer(ByteBuffer bb) {
        ByteBuffer byteBuffer;
        p.a(bb);
        Constructor<?> constructor = mbBBConstructor;
        if (constructor != null) {
            return MessageBuffer.newInstance(constructor, byteBuffer);
        }
        return new MessageBuffer(byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private static MessageBuffer newInstance(Constructor<?> constructor, Object ... args) {
        try {
            void var1_4;
            return (MessageBuffer)constructor.newInstance((Object[])var1_4);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getCause() instanceof RuntimeException)) {
                if (invocationTargetException.getCause() instanceof Error) {
                    throw (Error)invocationTargetException.getCause();
                }
                throw new IllegalStateException(invocationTargetException.getCause());
            }
            throw (RuntimeException)invocationTargetException.getCause();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
    }

    public static void releaseBuffer(MessageBuffer buffer) {
        MessageBuffer messageBuffer;
        if (!isUniversalBuffer && !messageBuffer.hasArray()) {
            if (f.c((Object)messageBuffer.reference)) {
                f.a((Object)messageBuffer.reference);
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    MessageBuffer(byte[] arr, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessageBuffer messageBuffer = this;
        MessageBuffer messageBuffer2 = this;
        messageBuffer2.base = var1_1;
        messageBuffer2.address = ARRAY_BYTE_BASE_OFFSET + var2_2;
        messageBuffer.size = var3_3;
        messageBuffer.reference = null;
    }

    /*
     * WARNING - void declaration
     */
    MessageBuffer(ByteBuffer bb) {
        block6: {
            block5: {
                void var1_1;
                block4: {
                    if (!bb.isDirect()) break block4;
                    if (isUniversalBuffer) {
                        MessageBuffer messageBuffer = this;
                        MessageBuffer messageBuffer2 = this;
                        messageBuffer2.base = null;
                        messageBuffer2.address = 0L;
                        messageBuffer.size = var1_1.remaining();
                        messageBuffer.reference = null;
                        return;
                    }
                    this.base = null;
                    this.address = f.b(var1_1) + (long)var1_1.position();
                    this.size = var1_1.remaining();
                    this.reference = var1_1;
                    break block5;
                }
                if (!var1_1.hasArray()) break block6;
                MessageBuffer messageBuffer = this;
                MessageBuffer messageBuffer3 = this;
                messageBuffer3.base = var1_1.array();
                messageBuffer3.address = ARRAY_BYTE_BASE_OFFSET + var1_1.arrayOffset() + var1_1.position();
                messageBuffer.size = var1_1.remaining();
                messageBuffer.reference = null;
            }
            return;
        }
        throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer is supported");
    }

    /*
     * WARNING - void declaration
     */
    protected MessageBuffer(Object base, long address, int length) {
        void var4_3;
        void var2_2;
        void var1_1;
        this.base = var1_1;
        this.address = var2_2;
        this.size = var4_3;
        this.reference = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block26: {
            MessageBuffer.javaVersion = MessageBuffer.getJavaVersion();
            var0 = false;
            var1_7 = null;
            var2_8 = 16;
            var3_9 = 0;
            var3_9 = Class.forName("sun.misc.Unsafe") != null ? 1 : 0;
            ** GOTO lbl12
            {
                block29: {
                    block28: {
                        block27: {
                            catch (Throwable var3_10) {
                                break block26;
                            }
                            catch (Exception v0) {}
lbl12:
                            // 2 sources

                            try {
                                var4_12 = System.getProperty("java.runtime.name", "").toLowerCase(Locale.US).contains("android");
                                var5_13 = System.getProperty("com.google.appengine.runtime.version") != null;
                                var0 = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false")) || var4_12 || var5_13 || MessageBuffer.javaVersion < 7 || var3_9 == 0;
                                if (var0) break block27;
                                v1 = Unsafe.class.getDeclaredField("theUnsafe");
                                v1.setAccessible(true);
                                var1_7 = (Unsafe)v1.get(null);
                                if (var1_7 == null) throw new RuntimeException("Unsafe is unavailable");
                                v2 = var1_7;
                                var2_8 = v2.arrayBaseOffset(byte[].class);
                                var3_9 = v2.arrayIndexScale(byte[].class);
                                if (var3_9 == 1) break block27;
                                throw new IllegalStateException("Byte array index scale must be 1, but is " + var3_9);
                            }
                            catch (Exception var3_11) {}
                        }
                        MessageBuffer.unsafe = var1_7;
                        MessageBuffer.ARRAY_BYTE_BASE_OFFSET = var2_8;
                        MessageBuffer.isUniversalBuffer = var0;
                        var0_1 = MessageBuffer.isUniversalBuffer != false ? "com.batch.android.msgpack.core.buffer.MessageBufferU" : (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN != false ? "com.batch.android.msgpack.core.buffer.MessageBuffer" : "com.batch.android.msgpack.core.buffer.MessageBufferBE");
                        if (!"com.batch.android.msgpack.core.buffer.MessageBuffer".equals(var0_1)) {
                            try {
                                v3 = Class.forName(var0_1);
                                v4 = v3.getDeclaredConstructor(new Class[]{byte[].class, Integer.TYPE, Integer.TYPE});
                                v4.setAccessible(true);
                                MessageBuffer.mbArrConstructor = v4;
                                v5 = v3.getDeclaredConstructor(new Class[]{ByteBuffer.class});
                                v5.setAccessible(true);
                                MessageBuffer.mbBBConstructor = v5;
                                return;
                            }
                            catch (Exception var0_2) {
                                var0_2.printStackTrace(System.err);
                                throw new RuntimeException(var0_2);
                            }
                        }
                        break block28;
                        {
                            var3_11.printStackTrace(System.err);
                            MessageBuffer.unsafe = var1_7;
                            MessageBuffer.ARRAY_BYTE_BASE_OFFSET = var2_8;
                            MessageBuffer.isUniversalBuffer = true;
                        }
                        var0_3 = "com.batch.android.msgpack.core.buffer.MessageBufferU";
                        if (!"com.batch.android.msgpack.core.buffer.MessageBuffer".equals(var0_3)) break block29;
                    }
                    MessageBuffer.mbArrConstructor = null;
                    MessageBuffer.mbBBConstructor = null;
                    return;
                }
                try {
                    v6 = Class.forName(var0_3);
                    v7 = v6.getDeclaredConstructor(new Class[]{byte[].class, Integer.TYPE, Integer.TYPE});
                    v7.setAccessible(true);
                    MessageBuffer.mbArrConstructor = v7;
                    v8 = v6.getDeclaredConstructor(new Class[]{ByteBuffer.class});
                    v8.setAccessible(true);
                    MessageBuffer.mbBBConstructor = v8;
                    return;
                }
                catch (Exception var0_4) {
                    var0_4.printStackTrace(System.err);
                    throw new RuntimeException(var0_4);
                }
            }
        }
        MessageBuffer.unsafe = var1_7;
        MessageBuffer.ARRAY_BYTE_BASE_OFFSET = var2_8;
        MessageBuffer.isUniversalBuffer = var0;
        var0_5 = MessageBuffer.isUniversalBuffer != false ? "com.batch.android.msgpack.core.buffer.MessageBufferU" : (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN != false ? "com.batch.android.msgpack.core.buffer.MessageBuffer" : "com.batch.android.msgpack.core.buffer.MessageBufferBE");
        if ("com.batch.android.msgpack.core.buffer.MessageBuffer".equals(var0_5)) {
            MessageBuffer.mbArrConstructor = null;
            MessageBuffer.mbBBConstructor = null;
            throw var3_10;
        }
        try {
            v9 = Class.forName(var0_5);
            v10 = v9.getDeclaredConstructor(new Class[]{byte[].class, Integer.TYPE, Integer.TYPE});
            v10.setAccessible(true);
            MessageBuffer.mbArrConstructor = v10;
            v11 = v9.getDeclaredConstructor(new Class[]{ByteBuffer.class});
            v11.setAccessible(true);
            MessageBuffer.mbBBConstructor = v11;
        }
        catch (Exception var0_6) {
            var0_6.printStackTrace(System.err);
            throw new RuntimeException(var0_6);
        }
        throw var3_10;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public MessageBuffer slice(int offset, int length) {
        void var1_1;
        void var2_2;
        if (offset == 0 && var2_2 == this.size()) {
            return this;
        }
        p.a(var1_1 + var2_2 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(int index) {
        void var1_1;
        return unsafe.getByte(this.base, this.address + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int index) {
        void var1_1;
        return unsafe.getBoolean(this.base, this.address + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(int index) {
        void var1_1;
        return Short.reverseBytes(unsafe.getShort(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int index) {
        void var1_1;
        return Integer.reverseBytes(unsafe.getInt(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(int index) {
        void var1_1;
        return Float.intBitsToFloat(this.getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int index) {
        void var1_1;
        return Long.reverseBytes(unsafe.getLong(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int index) {
        void var1_1;
        return Double.longBitsToDouble(this.getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(int index, byte[] dst, int dstOffset, int length) {
        void var2_2;
        void var4_5;
        void var3_3;
        void var1_1;
        MessageBuffer messageBuffer = object;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address + (long)var1_1;
        long l3 = ARRAY_BYTE_BASE_OFFSET + var3_3;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, var2_2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(int index, int len, ByteBuffer dst) {
        void var2_2;
        if (dst.remaining() >= var2_2) {
            void var1_1;
            void var3_3;
            var3_3.put(this.sliceAsByteBuffer((int)var1_1, (int)var2_2));
            return;
        }
        throw new BufferOverflowException();
    }

    /*
     * WARNING - void declaration
     */
    public void putByte(int index, byte v2) {
        void var2_2;
        void var1_1;
        unsafe.putByte(this.base, this.address + (long)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putBoolean(int index, boolean v2) {
        void var2_2;
        void var1_1;
        unsafe.putBoolean(this.base, this.address + (long)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putShort(int index, short v2) {
        void var1_1;
        short s2 = Short.reverseBytes(v2);
        unsafe.putShort(this.base, this.address + (long)var1_1, s2);
    }

    /*
     * WARNING - void declaration
     */
    public void putInt(int index, int v2) {
        void var1_1;
        int n2 = Integer.reverseBytes(v2);
        unsafe.putInt(this.base, this.address + (long)var1_1, n2);
    }

    /*
     * WARNING - void declaration
     */
    public void putFloat(int index, float v2) {
        void var2_2;
        void var1_1;
        this.putInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void putLong(int index, long l2) {
        void var1_1;
        long l3 = Long.reverseBytes(l2);
        unsafe.putLong(this.base, this.address + (long)var1_1, l3);
    }

    /*
     * WARNING - void declaration
     */
    public void putDouble(int index, double v2) {
        void var1_1;
        void var2_2;
        long l2 = Double.doubleToRawLongBits((double)var2_2);
        this.putLong((int)var1_1, l2);
    }

    /*
     * WARNING - void declaration
     */
    public void putBytes(int index, byte[] src, int srcOffset, int length) {
        void var2_2;
        void var4_5;
        void var1_1;
        void var3_4;
        MessageBuffer messageBuffer = object;
        long l2 = ARRAY_BYTE_BASE_OFFSET + var3_4;
        Object object = messageBuffer.base;
        long l3 = messageBuffer.address + (long)var1_1;
        long l4 = (long)var4_5;
        unsafe.copyMemory(var2_2, l2, object, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public void putByteBuffer(int index, ByteBuffer src, int len) {
        void var2_4;
        if (len <= var2_4.remaining()) {
            if (!isUniversalBuffer) {
                int n2;
                void var1_1;
                Object object;
                if (var2_4.isDirect()) {
                    void v0 = var2_4;
                    MessageBuffer messageBuffer = object;
                    long l2 = f.b(var2_4) + (long)var2_4.position();
                    object = messageBuffer.base;
                    long l3 = messageBuffer.address + (long)var1_1;
                    long l4 = n2;
                    unsafe.copyMemory(null, l2, object, l3, l4);
                    v0.position(v0.position() + n2);
                } else if (var2_4.hasArray()) {
                    void v2 = var2_4;
                    MessageBuffer messageBuffer = object;
                    long l5 = ARRAY_BYTE_BASE_OFFSET + var2_4.position();
                    object = messageBuffer.base;
                    long l6 = messageBuffer.address + (long)var1_1;
                    long l7 = n2;
                    unsafe.copyMemory(v2.array(), l5, object, l6, l7);
                    v2.position(v2.position() + n2);
                } else if (((MessageBuffer)object).hasArray()) {
                    var2_4.get((byte[])((MessageBuffer)object).base, (int)var1_1, n2);
                } else {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        MessageBuffer messageBuffer = object;
                        Object object2 = messageBuffer.base;
                        long l8 = messageBuffer.address + (long)var1_1;
                        byte by = var2_4.get();
                        unsafe.putByte(object2, l8, by);
                    }
                }
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public void putMessageBuffer(int index, MessageBuffer src, int srcOffset, int len) {
        void var4_5;
        void var1_1;
        void var3_4;
        void var2_2;
        MessageBuffer messageBuffer = object;
        void v1 = var2_2;
        Object object = v1.base;
        long l2 = v1.address + (long)var3_4;
        Object object2 = messageBuffer.base;
        long l3 = messageBuffer.address + (long)var1_1;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, object2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer sliceAsByteBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        if (this.hasArray()) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)var1_1), (int)var2_2);
        }
        if (!isUniversalBuffer) {
            return f.a(this.address, (int)var1_1, (int)var2_2, this.reference);
        }
        throw new IllegalStateException();
    }

    public ByteBuffer sliceAsByteBuffer() {
        MessageBuffer messageBuffer = this;
        return messageBuffer.sliceAsByteBuffer(0, messageBuffer.size());
    }

    public boolean hasArray() {
        return this.base != null;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        MessageBuffer messageBuffer = this;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address;
        long l3 = ARRAY_BYTE_BASE_OFFSET;
        long l4 = this.size();
        unsafe.copyMemory(object, l2, byArray, l3, l4);
        return byArray;
    }

    public byte[] array() {
        return (byte[])this.base;
    }

    public int arrayOffset() {
        return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(int index, MessageBuffer dst, int offset, int length) {
        void var4_5;
        void var3_4;
        void var1_1;
        void var2_3;
        void v0 = var2_3;
        MessageBuffer messageBuffer = object;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address + (long)var1_1;
        Object object2 = v0.base;
        long l3 = v0.address + (long)var3_4;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, object2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public String toHexString(int offset, int length) {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (void var4_4 = var1_1; var4_4 < var2_2; ++var4_4) {
            void var1_1;
            if (var4_4 != var1_1) {
                stringBuilder2.append(" ");
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.getByte((int)var4_4);
            stringBuilder2.append(String.format("%02x", objectArray2));
        }
        return stringBuilder2.toString();
    }
}

