/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.batch.android.BatchPushPayload;
import com.batch.android.a.a;
import com.batch.android.c.r;
import com.batch.android.i.h;

@a
public final class BatchNotificationChannelsManager {
    @Nullable
    private String a = null;
    @Nullable
    private ChannelNameProvider b = null;
    @Nullable
    private NotificationChannelIdInterceptor c = null;
    public static final String DEFAULT_CHANNEL_ID = "_BATCHSDK_DEFAULT";

    @NonNull
    String a(@Nullable BatchPushPayload batchPushPayload) {
        String string2 = DEFAULT_CHANNEL_ID;
        if (this.a != null) {
            string2 = this.a;
        }
        if (batchPushPayload != null && this.c != null) {
            try {
                String string3 = this.c.getChannelId(batchPushPayload, string2);
                if (string3 != null) {
                    string2 = string3;
                }
            }
            catch (Exception exception) {
                r.d("Push", "An exception occurred while calling the specified channel id interceptor. Falling back on '" + string2 + "'", exception);
            }
        }
        return string2;
    }

    private boolean b() {
        return this.a == null;
    }

    void a(Context context) {
        if (Build.VERSION.SDK_INT >= 26 && this.b()) {
            r.e("Push", "Registering default Batch notification channel");
            NotificationChannel notificationChannel = new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)this.a(), 3);
            notificationChannel.setShowBadge(true);
            notificationChannel.enableLights(true);
            notificationChannel.enableVibration(true);
            Uri uri = h.t().p();
            if (uri != null) {
                notificationChannel.setSound(uri, new AudioAttributes.Builder().setUsage(5).build());
            }
            NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    String a() {
        String string2 = null;
        if (this.b != null) {
            try {
                string2 = this.b.getDefaultChannelName();
            }
            catch (Exception exception) {
                r.d("Push", "An exception occurred while calling the specified channel id interceptor. Falling back on the default name.", exception);
            }
        }
        if (TextUtils.isEmpty(string2)) {
            string2 = "Notifications";
        }
        return string2;
    }

    public void setChannelIdOverride(@Nullable String channelId) {
        this.a = channelId;
    }

    public void setChannelNameProvider(@Nullable ChannelNameProvider provider) {
        this.b = provider;
    }

    public void setChannelName(@NonNull Context context, @StringRes int channelNameResourceId) {
        this.setChannelNameProvider(new StringResChannelNameProvider(context, channelNameResourceId));
    }

    public void setChannelIdInterceptor(@Nullable NotificationChannelIdInterceptor interceptor) {
        this.c = interceptor;
    }

    public static boolean openSystemChannelSettings(@NonNull Context context) {
        return BatchNotificationChannelsManager.openSystemChannelSettings(context, DEFAULT_CHANNEL_ID);
    }

    public static boolean openSystemChannelSettings(@NonNull Context context, @NonNull String channelId) {
        if (context == null) {
            throw new IllegalArgumentException("Context is mandatory");
        }
        if (channelId == null) {
            throw new IllegalArgumentException("ChannelId is mandatory");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                Intent intent = new Intent("android.settings.CHANNEL_NOTIFICATION_SETTINGS");
                intent.putExtra("android.provider.extra.CHANNEL_ID", channelId);
                intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                context.startActivity(intent);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @a
    public static interface NotificationChannelIdInterceptor {
        @Nullable
        public String getChannelId(@NonNull BatchPushPayload var1, String var2);
    }

    @a
    public static final class StringResChannelNameProvider
    implements ChannelNameProvider {
        private Context a;
        private int b;

        public StringResChannelNameProvider(@NonNull Context context, @StringRes int channelNameResourceId) {
            this.a = context.getApplicationContext();
            this.b = channelNameResourceId;
        }

        @Override
        @NonNull
        public String getDefaultChannelName() {
            return this.a.getResources().getString(this.b);
        }
    }

    @a
    public static interface ChannelNameProvider {
        @NonNull
        public String getDefaultChannelName();
    }
}

