/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.batch.android.json.JSONStringer;
import com.batch.android.json.JSONTokener;
import com.batch.android.json.a;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JSONArray {
    private final List<Object> a;

    public JSONArray() {
        this.a = new ArrayList<Object>();
    }

    public JSONArray(Collection object) {
        this();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.put(JSONObject.wrap(object.next()));
            }
        }
    }

    public JSONArray(JSONTokener object) throws JSONException {
        object = ((JSONTokener)object).nextValue();
        if (object instanceof JSONArray) {
            this.a = ((JSONArray)object).a;
            return;
        }
        com.batch.android.json.a.a(object, "JSONArray");
        throw null;
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Object object) throws JSONException {
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            this.a = new ArrayList<Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.put(JSONObject.wrap(Array.get(object, i2)));
            }
            return;
        }
        throw new JSONException("Not a primitive array: " + object.getClass());
    }

    public int length() {
        return this.a.size();
    }

    public JSONArray put(boolean bl) {
        JSONArray jSONArray = this;
        jSONArray.a.add(bl);
        return jSONArray;
    }

    public JSONArray put(double d2) throws JSONException {
        JSONArray jSONArray = this;
        jSONArray.a.add(com.batch.android.json.a.a(d2));
        return jSONArray;
    }

    public JSONArray put(int n2) {
        JSONArray jSONArray = this;
        jSONArray.a.add(n2);
        return jSONArray;
    }

    public JSONArray put(long l2) {
        JSONArray jSONArray = this;
        jSONArray.a.add(l2);
        return jSONArray;
    }

    public JSONArray put(Object object) {
        JSONArray jSONArray = this;
        jSONArray.a.add(object);
        return jSONArray;
    }

    void a(Object object) throws JSONException {
        if (object instanceof Number) {
            com.batch.android.json.a.a(((Number)object).doubleValue());
        }
        this.put(object);
    }

    public JSONArray put(int n2, boolean bl) throws JSONException {
        return this.put(n2, (Object)bl);
    }

    public JSONArray put(int n2, double d2) throws JSONException {
        return this.put(n2, (Object)d2);
    }

    public JSONArray put(int n2, int n3) throws JSONException {
        return this.put(n2, (Object)n3);
    }

    public JSONArray put(int n2, long l2) throws JSONException {
        return this.put(n2, (Object)l2);
    }

    public JSONArray put(int n2, Object object) throws JSONException {
        if (object instanceof Number) {
            com.batch.android.json.a.a(((Number)object).doubleValue());
        }
        while (this.a.size() <= n2) {
            this.a.add(null);
        }
        JSONArray jSONArray = this;
        jSONArray.a.set(n2, object);
        return jSONArray;
    }

    public boolean isNull(int n2) {
        return (this = ((JSONArray)this).opt(n2)) == null || this == JSONObject.NULL;
    }

    public Object get(int n2) throws JSONException {
        JSONException jSONException;
        block5: {
            try {
                Object object = this.a.get(n2);
                if (object == null) break block5;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new JSONException("Index " + n2 + " out of range [0.." + this.a.size() + ")");
            }
        }
        JSONException jSONException2 = jSONException;
        JSONException jSONException3 = jSONException;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Value at ").append(n2);
        jSONException2(stringBuilder2.append(" is null.").toString());
        throw jSONException3;
    }

    public Object opt(int n2) {
        if (n2 >= 0 && n2 < this.a.size()) {
            return this.a.get(n2);
        }
        return null;
    }

    public Object remove(int n2) {
        if (n2 >= 0 && n2 < this.a.size()) {
            return this.a.remove(n2);
        }
        return null;
    }

    public boolean getBoolean(int n2) throws JSONException {
        Boolean bl = com.batch.android.json.a.a(this = ((JSONArray)this).get(n2));
        if (bl != null) {
            return bl;
        }
        com.batch.android.json.a.a(n2, this, "boolean");
        throw null;
    }

    public boolean optBoolean(int n2) {
        return this.optBoolean(n2, false);
    }

    public boolean optBoolean(int n2, boolean bl) {
        if ((this = com.batch.android.json.a.a(((JSONArray)this).opt(n2))) != null) {
            bl = (Boolean)this;
        }
        return bl;
    }

    public double getDouble(int n2) throws JSONException {
        Double d2 = com.batch.android.json.a.b(this = ((JSONArray)this).get(n2));
        if (d2 != null) {
            return d2;
        }
        com.batch.android.json.a.a(n2, this, "double");
        throw null;
    }

    public double optDouble(int n2) {
        return this.optDouble(n2, Double.NaN);
    }

    public double optDouble(int n2, double d2) {
        if ((this = com.batch.android.json.a.b(((JSONArray)this).opt(n2))) != null) {
            d2 = (Double)this;
        }
        return d2;
    }

    public int getInt(int n2) throws JSONException {
        Integer n3 = com.batch.android.json.a.c(this = ((JSONArray)this).get(n2));
        if (n3 != null) {
            return n3;
        }
        com.batch.android.json.a.a(n2, this, "int");
        throw null;
    }

    public int optInt(int n2) {
        return this.optInt(n2, 0);
    }

    public int optInt(int n2, int n3) {
        if ((this = com.batch.android.json.a.c(((JSONArray)this).opt(n2))) != null) {
            n3 = (Integer)this;
        }
        return n3;
    }

    public long getLong(int n2) throws JSONException {
        Long l2 = com.batch.android.json.a.d(this = ((JSONArray)this).get(n2));
        if (l2 != null) {
            return l2;
        }
        com.batch.android.json.a.a(n2, this, "long");
        throw null;
    }

    public long optLong(int n2) {
        return this.optLong(n2, 0L);
    }

    public long optLong(int n2, long l2) {
        if ((this = com.batch.android.json.a.d(((JSONArray)this).opt(n2))) != null) {
            l2 = (Long)this;
        }
        return l2;
    }

    public String getString(int n2) throws JSONException {
        String string = com.batch.android.json.a.e(this = ((JSONArray)this).get(n2));
        if (string != null) {
            return string;
        }
        com.batch.android.json.a.a(n2, this, "String");
        throw null;
    }

    public String optString(int n2) {
        return this.optString(n2, "");
    }

    public String optString(int n2, String string) {
        if ((object = com.batch.android.json.a.e(((JSONArray)object).opt(n2))) == null) {
            Object object = string;
        }
        return object;
    }

    public JSONArray getJSONArray(int n2) throws JSONException {
        if ((this = ((JSONArray)this).get(n2)) instanceof JSONArray) {
            return (JSONArray)this;
        }
        com.batch.android.json.a.a(n2, this, "JSONArray");
        throw null;
    }

    public JSONArray optJSONArray(int n2) {
        return (this = ((JSONArray)this).opt(n2)) instanceof JSONArray ? (JSONArray)this : null;
    }

    public JSONObject getJSONObject(int n2) throws JSONException {
        if ((this = ((JSONArray)this).get(n2)) instanceof JSONObject) {
            return (JSONObject)this;
        }
        com.batch.android.json.a.a(n2, this, "JSONObject");
        throw null;
    }

    public JSONObject optJSONObject(int n2) {
        return (this = ((JSONArray)this).opt(n2)) instanceof JSONObject ? (JSONObject)this : null;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        int n2 = Math.min(jSONArray.length(), this.a.size());
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONObject2.put(com.batch.android.json.a.e(jSONArray.opt(i2)), this.opt(i2));
        }
        return jSONObject2;
    }

    public String join(String string) throws JSONException {
        JSONStringer jSONStringer;
        JSONStringer jSONStringer2 = jSONStringer;
        new JSONStringer().a(JSONStringer.a.f, "");
        int n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                jSONStringer2.a.append(string);
            }
            jSONStringer2.value(this.a.get(i2));
        }
        JSONStringer jSONStringer3 = jSONStringer2;
        JSONStringer.a a2 = JSONStringer.a.f;
        jSONStringer3.a(a2, a2, "");
        return jSONStringer3.a.toString();
    }

    public String toString() {
        try {
            JSONStringer jSONStringer;
            JSONArray jSONArray = jSONStringer2;
            JSONStringer jSONStringer2 = jSONStringer;
            jSONArray.a(new JSONStringer());
            return jSONStringer2.toString();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toString(int n2) throws JSONException {
        JSONStringer jSONStringer;
        JSONArray jSONArray = jSONStringer2;
        JSONStringer jSONStringer2 = jSONStringer;
        jSONArray.a(new JSONStringer(n2));
        return jSONStringer2.toString();
    }

    void a(JSONStringer jSONStringer) throws JSONException {
        jSONStringer.array();
        Iterator<Object> iterator = ((JSONArray)((Object)iterator)).a.iterator();
        while (iterator.hasNext()) {
            jSONStringer.value(iterator.next());
        }
        jSONStringer.endArray();
    }

    public boolean equals(Object object) {
        return object instanceof JSONArray && ((JSONArray)object).a.equals(this.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

