package com.bandyer.communication_center.live_pointer

import com.bandyer.communication_center.call.Call
import com.bandyer.communication_center.live_pointer.model.PointerEvent

/**
 * Pointer events listener.
 */
interface PointerEventListener {
    /**
     * Called when a new pointer event has been sent.
     * @param call the call referred
     * @param pointerEvent current PointerEvent
     */
    fun onPointerEvent(call: Call, pointerEvent: PointerEvent)

    /**
     * Called when the pointer became idle.
     * @param call the call referred
     * @param lastPointerEvent the last PointerEvent
     */
    fun onPointerIdle(call: Call, lastPointerEvent: PointerEvent)
}
