/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class Datapoint {
    private String metric;
    private String field;
    private Map<String, String> tags;
    private String type;
    private List<List<JsonNode>> values;

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getType() {
        return this.type;
    }

    public List<List<JsonNode>> getValues() {
        return this.values;
    }

    public void setValues(List<List<JsonNode>> values) {
        this.values = values;
    }

    public Datapoint withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public Datapoint withField(String field) {
        this.field = field;
        return this;
    }

    public Datapoint withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Datapoint addLongValue(long time, long value) {
        this.initialValues("Long");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new LongNode(value)}));
        return this;
    }

    public Datapoint addDoubleValue(long time, double value) {
        this.initialValues("Double");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new DoubleNode(value)}));
        return this;
    }

    public Datapoint addStringValue(long time, String value) {
        this.initialValues("String");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new TextNode(value)}));
        return this;
    }

    public Datapoint addBytesValue(long time, byte[] value) {
        this.initialValues("Bytes");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new BinaryNode(value)}));
        return this;
    }

    public Datapoint addBigDecimalValue(long time, BigDecimal value) {
        this.initialValues("BigDecimal");
        this.values.add(Lists.newArrayList((Object[])new JsonNode[]{new LongNode(time), new TextNode(String.valueOf(value))}));
        return this;
    }

    public Datapoint addTag(String tagKey, String tagValue) {
        this.initialTags();
        this.tags.put(tagKey, tagValue);
        return this;
    }

    private void initialValues(String inputType) {
        if (this.values == null) {
            this.values = Lists.newArrayList();
            this.type = inputType;
            return;
        }
        if (!this.type.equals(inputType)) {
            throw new IllegalStateException("There is already " + this.type + " type in datapoint, could not add " + inputType + " type again");
        }
    }

    private void initialTags() {
        if (this.tags == null) {
            this.tags = Maps.newHashMap();
        }
    }
}

