/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ocr;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.services.ocr.model.BankcardRecognitionRequest;
import com.baidubce.services.ocr.model.BankcardRecognitionResponse;
import com.baidubce.services.ocr.model.FormAbstractBceRequest;
import com.baidubce.services.ocr.model.GeneralRecognitionRequest;
import com.baidubce.services.ocr.model.GeneralRecognitionResponse;
import com.baidubce.services.ocr.model.IdcardRecognitionRequest;
import com.baidubce.services.ocr.model.IdcardRecognitionResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class OcrClient
extends AbstractBceClient {
    private static final String VERSION = "api/v1";
    private static final String PATH_OCR = "ocr";
    private static final String PARA_GENERAL = "general";
    private static final String PARA_BANK = "bankcard";
    private static final String PARA_ID = "idcard";
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public OcrClient(BceClientConfiguration ocrConfig) {
        super(ocrConfig, responseHandlers, true);
    }

    public BankcardRecognitionResponse bankcardRecognition(String image) {
        BankcardRecognitionRequest request = new BankcardRecognitionRequest().withImage(image);
        return this.bankcardRecognition(request);
    }

    public BankcardRecognitionResponse bankcardRecognition(BankcardRecognitionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImage(), "Image should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PARA_BANK);
        return this.invokeHttpClient(internalRequest, BankcardRecognitionResponse.class);
    }

    public IdcardRecognitionResponse idcardRecognition(String image, String side) {
        IdcardRecognitionRequest request = new IdcardRecognitionRequest().withImage(image).withSide(side);
        return this.idcardRecognition(request);
    }

    public IdcardRecognitionResponse idcardRecognition(String image, String side, Boolean direction) {
        IdcardRecognitionRequest request = new IdcardRecognitionRequest().withImage(image).withSide(side).withDirection(direction);
        return this.idcardRecognition(request);
    }

    public IdcardRecognitionResponse idcardRecognition(IdcardRecognitionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImage(), "Image should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PARA_ID);
        return this.invokeHttpClient(internalRequest, IdcardRecognitionResponse.class);
    }

    public GeneralRecognitionResponse generalRecognition(String image) {
        GeneralRecognitionRequest request = new GeneralRecognitionRequest().withImage(image);
        return this.generalRecognition(request);
    }

    public GeneralRecognitionResponse generalRecognition(String image, String granularity, String mask, String langType, Boolean direction) {
        GeneralRecognitionRequest request = new GeneralRecognitionRequest().withImage(image).withGranularity(granularity).withMask(mask).withLangType(langType).withDirection(direction);
        return this.generalRecognition(request);
    }

    public GeneralRecognitionResponse generalRecognition(GeneralRecognitionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImage(), "Image should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PARA_GENERAL);
        return this.invokeHttpClient(internalRequest, GeneralRecognitionResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, FormAbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        pathComponents.add(PATH_OCR);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, FormAbstractBceRequest request) {
        String strFormParameters = request.toFormString();
        byte[] requestJson = null;
        try {
            requestJson = strFormParameters.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", FORM_CONTENT_TYPE);
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

