/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.util.JsonUtils;
import java.util.HashMap;

public class KeySchemaElement {
    public static final String HASH_KEY_TYPE = "Hash";
    public static final String RANGE_KEY_TYPE = "Range";
    private String attributeName;
    private String keyType;

    public KeySchemaElement() {
    }

    public KeySchemaElement(String attributeName, String keyType) {
        this.attributeName = attributeName;
        this.keyType = keyType;
    }

    public void setAttributeName(String name) {
        this.attributeName = name;
    }

    public KeySchemaElement withAttributeName(String name) {
        this.setAttributeName(name);
        return this;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setKeyType(String type) {
        this.keyType = type;
    }

    public KeySchemaElement withKeyType(String type) {
        this.setKeyType(type);
        return this;
    }

    public String getKeyType() {
        return this.keyType;
    }

    protected Object toJsonObj() {
        if (this.keyType == null) {
            throw new NullPointerException("Invalid key schema element. Key type is null");
        }
        if (this.attributeName == null) {
            throw new NullPointerException("Invalid key schema element. Attribute name is null");
        }
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("attributeName", this.attributeName);
        obj.put("keyType", this.keyType);
        return obj;
    }

    public String toString() {
        return JsonUtils.toJsonString(this.toJsonObj());
    }
}

