/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cnap.model.cluster;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cnap.model.cluster.NewClusterModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ImportClusterRequest
extends AbstractBceRequest {
    private List<Map<String, String>> workspaceList;
    private NewClusterModel cluster;

    public void setWorkspaceList(List<String> workspaceList) {
        if (CollectionUtils.isEmpty(workspaceList)) {
            return;
        }
        this.workspaceList = new LinkedList<Map<String, String>>();
        for (String workspaceID : workspaceList) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("workspaceID", workspaceID);
            this.workspaceList.add(info);
        }
    }

    public NewClusterModel getCluster() {
        return this.cluster;
    }

    public void setCluster(NewClusterModel cluster) {
        this.cluster = cluster;
    }

    public ImportClusterRequest withWorkspaceList(List<String> workspaceList) {
        this.setWorkspaceList(workspaceList);
        return this;
    }

    public ImportClusterRequest withNewClusterModel(NewClusterModel model) {
        this.setCluster(model);
        return this;
    }

    @Override
    public ImportClusterRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}

