/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bmr.model;

import com.baidubce.services.bmr.model.StepConfig;

public class JavaStepConfig
extends StepConfig {
    private static final String JAVA_STEP = "Java";
    private static final String JAR = "jar";
    private static final String MAIN_CLASS = "mainClass";
    private static final String ARGUMENTS = "arguments";

    public JavaStepConfig() {
        this.setType(JAVA_STEP);
    }

    public JavaStepConfig withJar(String jar) {
        this.addProperty(JAR, jar);
        return this;
    }

    public JavaStepConfig withMainClass(String mainClass) {
        this.addProperty(MAIN_CLASS, mainClass);
        return this;
    }

    public JavaStepConfig withArguments(String arguments) {
        this.addProperty(ARGUMENTS, arguments);
        return this;
    }

    @Override
    public JavaStepConfig withActionOnFailure(String actionOnFailure) {
        this.setActionOnFailure(actionOnFailure);
        return this;
    }

    @Override
    public JavaStepConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public JavaStepConfig withAdditionalFile(String remote, String local) {
        this.addAdditionalFile(remote, local);
        return this;
    }
}

