/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper;

import com.baidu.xuper.Contract;
import com.baidu.xuper.NativeCodeService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Driver {
    private static final String XCHAIN_CHAIN_ADDR = "XCHAIN_CHAIN_ADDR";
    private static final String XCHAIN_CODE_PORT = "XCHAIN_CODE_PORT";

    public static void serve(Contract contract) {
        try {
            String chainAddr = System.getenv(XCHAIN_CHAIN_ADDR);
            NativeCodeService codeService = NativeCodeService.newNativeCodeService(chainAddr, contract);
            int codePort = Integer.parseInt(System.getenv(XCHAIN_CODE_PORT));
            Server server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress("127.0.0.1", codePort)).addService((BindableService)codeService)).build();
            server.start();
            Driver.waitAndKeepAlive(codeService);
            server.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void waitAndKeepAlive(NativeCodeService codeService) {
        try {
            while (true) {
                codeService.pingXchain();
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            System.out.println("ping xchain node error " + e.toString());
            return;
        }
    }
}

