/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.CoordTrans;

public class CoordinateConverter {
    private LatLng a;
    private CoordType b;

    public CoordinateConverter coord(LatLng latLng) {
        this.a = latLng;
        return this;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.b = coordType;
        return this;
    }

    public LatLng convert() {
        if (this.a == null) {
            return null;
        }
        if (this.b == null) {
            this.b = CoordType.GPS;
        }
        switch (this.b) {
            case COMMON: {
                return CoordinateConverter.b(this.a);
            }
            case GPS: {
                return CoordinateConverter.a(this.a);
            }
            case BD09LL: {
                return CoordinateConverter.d(this.a);
            }
            case BD09MC: {
                return CoordinateConverter.c(this.a);
            }
        }
        return null;
    }

    private static LatLng a(LatLng latLng) {
        return CoordinateConverter.a(latLng, "wgs84");
    }

    private static LatLng b(LatLng latLng) {
        return CoordinateConverter.a(latLng, "gcj02");
    }

    private static LatLng c(LatLng latLng) {
        return CoordinateConverter.a(latLng, "bd09mc");
    }

    private static LatLng a(LatLng latLng, String string) {
        if (latLng == null) {
            return null;
        }
        float f2 = (float)latLng.longitude;
        float f3 = (float)latLng.latitude;
        return CoordUtil.Coordinate_encryptEx(f2, f3, string);
    }

    private static LatLng d(LatLng latLng) {
        if (null == latLng) {
            return null;
        }
        return CoordTrans.baiduToGcj(latLng);
    }

    public static enum CoordType {
        GPS,
        COMMON,
        BD09LL,
        BD09MC;

    }
}

