/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring.annotation;

import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.spring.RpcProxyFactoryBean;
import com.baidu.brpc.spring.RpcServiceExporter;
import com.baidu.brpc.spring.annotation.AbstractAnnotationParserCallback;
import com.baidu.brpc.spring.annotation.NamingOption;
import com.baidu.brpc.spring.annotation.RpcAnnotationResolverListener;
import com.baidu.brpc.spring.annotation.RpcExporter;
import com.baidu.brpc.spring.annotation.RpcProxy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class RpcAnnotationResolver
extends AbstractAnnotationParserCallback
implements InitializingBean {
    protected static final Log LOGGER = LogFactory.getLog(RpcAnnotationResolver.class);
    private List<RpcProxyFactoryBean> rpcClients = new ArrayList<RpcProxyFactoryBean>();
    private Map<Integer, RpcServiceExporter> portMappingExporters = new HashMap<Integer, RpcServiceExporter>();
    private Compiler compiler;
    private String namingServiceUrl;
    private NamingServiceFactory namingServiceFactory;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private RpcAnnotationResolverListener protobufRpcAnnotationResolverListener;

    @Override
    public Object annotationAtType(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (t instanceof RpcExporter) {
            LOGGER.info((Object)("Annotation 'RpcExporter' for target '" + beanName + "' created"));
            this.parseRpcExporterAnnotation((RpcExporter)t, beanFactory, beanFactory.getBean(beanName));
        }
        return bean;
    }

    private void parseRpcExporterAnnotation(RpcExporter rpcExporter, ConfigurableListableBeanFactory beanFactory, Object bean) {
        String interceptorNames;
        String rpcServerOptionsBeanName;
        RpcServerOptions rpcServerOptions;
        String port = this.parsePlaceholder(rpcExporter.port());
        int intPort = Integer.parseInt(port);
        RpcServiceExporter rpcServiceExporter = this.portMappingExporters.get(intPort);
        if (rpcServiceExporter == null) {
            rpcServiceExporter = new RpcServiceExporter();
            rpcServiceExporter.setServicePort(intPort);
            this.portMappingExporters.put(intPort, rpcServiceExporter);
        }
        if (StringUtils.isBlank((CharSequence)(rpcServerOptions = StringUtils.isBlank((CharSequence)(rpcServerOptionsBeanName = this.parsePlaceholder(rpcExporter.rpcServerOptionsBeanName()))) ? new RpcServerOptions() : (RpcServerOptions)beanFactory.getBean(rpcServerOptionsBeanName, RpcServerOptions.class)).getNamingServiceUrl())) {
            rpcServerOptions.setNamingServiceUrl(this.namingServiceUrl);
            rpcServiceExporter.setNamingServiceUrl(this.namingServiceUrl);
        }
        if (rpcExporter.useServiceSharedThreadPool()) {
            try {
                rpcServiceExporter.copyFrom(rpcServerOptions);
            }
            catch (Exception ex) {
                throw new RuntimeException("copy server options failed:", ex);
            }
        }
        if (!StringUtils.isBlank((CharSequence)(interceptorNames = this.parsePlaceholder(rpcExporter.interceptorBeanNames())))) {
            String[] interceptorNameArray;
            ArrayList<Interceptor> customInterceptors = new ArrayList<Interceptor>();
            for (String interceptorName : interceptorNameArray = interceptorNames.split(",")) {
                Interceptor interceptor = (Interceptor)beanFactory.getBean(interceptorName, Interceptor.class);
                customInterceptors.add(interceptor);
            }
            rpcServiceExporter.setInterceptors(customInterceptors);
        } else {
            rpcServiceExporter.setInterceptors(this.interceptors);
        }
        NamingOptions namingOptions = new NamingOptions();
        if (!rpcExporter.group().isEmpty()) {
            namingOptions.setGroup(this.parsePlaceholder(rpcExporter.group()));
        }
        if (!rpcExporter.version().isEmpty()) {
            namingOptions.setVersion(this.parsePlaceholder(rpcExporter.version()));
        }
        if (rpcExporter.extraOptions().length > 0) {
            namingOptions.setExtra(new HashMap());
            for (int i = 0; i < rpcExporter.extraOptions().length; ++i) {
                NamingOption opt = rpcExporter.extraOptions()[i];
                namingOptions.getExtra().put(opt.key(), this.parsePlaceholder(opt.value()));
            }
        }
        namingOptions.setIgnoreFailOfNamingService(rpcExporter.ignoreFailOfNamingService());
        rpcServiceExporter.getServiceNamingOptions().put(bean, namingOptions);
        if (rpcExporter.useServiceSharedThreadPool()) {
            rpcServiceExporter.getRegisterServices().add(bean);
        } else {
            rpcServiceExporter.getCustomOptionsServiceMap().put(rpcServerOptions, bean);
        }
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.onRpcExporterAnnotationParsered(rpcExporter, intPort, bean, rpcServiceExporter.getRegisterServices());
        }
    }

    @Override
    public void annotationAtTypeAfterStarted(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Collection<RpcServiceExporter> values = this.portMappingExporters.values();
        for (RpcServiceExporter rpcServiceExporter : values) {
            try {
                rpcServiceExporter.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object annotationAtField(Annotation t, Object value, String beanName, PropertyValues pvs, DefaultListableBeanFactory beanFactory, Field field) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                LOGGER.info((Object)("Annotation 'BrpcProxy' on field '" + field.getName() + "' for target '" + beanName + "' created"));
                return this.parseRpcProxyAnnotation((RpcProxy)t, field.getType(), beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return value;
    }

    private Object parseRpcProxyAnnotation(RpcProxy rpcProxy, Class serviceInterface, DefaultListableBeanFactory beanFactory) throws Exception {
        RpcProxyFactoryBean rpcProxyFactoryBean;
        String factoryBeanName = "&" + serviceInterface.getSimpleName();
        try {
            rpcProxyFactoryBean = (RpcProxyFactoryBean)((Object)beanFactory.getBean(factoryBeanName, RpcProxyFactoryBean.class));
            if (rpcProxyFactoryBean != null) {
                return rpcProxyFactoryBean.getObject();
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        String rpcClientOptionsBeanName = this.parsePlaceholder(rpcProxy.rpcClientOptionsBeanName());
        RpcClientOptions rpcClientOptions = StringUtils.isBlank((CharSequence)rpcClientOptionsBeanName) ? new RpcClientOptions() : (RpcClientOptions)beanFactory.getBean(rpcClientOptionsBeanName, RpcClientOptions.class);
        String actualNamingServiceUrl = StringUtils.isNotBlank((CharSequence)rpcProxy.namingServiceUrl()) ? this.parsePlaceholder(rpcProxy.namingServiceUrl()) : this.namingServiceUrl;
        rpcProxyFactoryBean = this.createRpcProxyFactoryBean(rpcProxy, serviceInterface, beanFactory, rpcClientOptions, actualNamingServiceUrl);
        this.rpcClients.add(rpcProxyFactoryBean);
        Object object = rpcProxyFactoryBean.getObject();
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.onRpcProxyAnnotationParsed(rpcProxy, rpcProxyFactoryBean, rpcProxyFactoryBean.getObject());
        }
        return object;
    }

    protected RpcProxyFactoryBean createRpcProxyFactoryBean(RpcProxy rpcProxy, Class serviceInterface, DefaultListableBeanFactory beanFactory, RpcClientOptions rpcClientOptions, String namingServiceUrl) {
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(RpcProxyFactoryBean.class);
        MutablePropertyValues values = new MutablePropertyValues();
        for (Field field : rpcClientOptions.getClass().getDeclaredFields()) {
            try {
                if (field.getType().equals(Logger.class)) continue;
                field.setAccessible(true);
                values.addPropertyValue(field.getName(), field.get(rpcClientOptions));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"field not exist:", (Throwable)ex);
            }
        }
        values.addPropertyValue("serviceInterface", (Object)serviceInterface);
        values.addPropertyValue("namingServiceUrl", (Object)namingServiceUrl);
        values.addPropertyValue("group", (Object)rpcProxy.group());
        values.addPropertyValue("version", (Object)rpcProxy.version());
        values.addPropertyValue("ignoreFailOfNamingService", (Object)rpcProxy.ignoreFailOfNamingService());
        values.addPropertyValue("serviceId", (Object)rpcProxy.name());
        String interceptorNames = this.parsePlaceholder(rpcProxy.interceptorBeanNames());
        if (!StringUtils.isBlank((CharSequence)interceptorNames)) {
            String[] interceptorNameArray;
            ArrayList<Interceptor> customInterceptors = new ArrayList<Interceptor>();
            for (String interceptorName : interceptorNameArray = interceptorNames.split(",")) {
                Interceptor interceptor = (Interceptor)beanFactory.getBean(interceptorName, Interceptor.class);
                customInterceptors.add(interceptor);
            }
            values.addPropertyValue("interceptors", customInterceptors);
        } else {
            values.addPropertyValue("interceptors", this.interceptors);
        }
        beanDef.setPropertyValues(values);
        String serviceInterfaceBeanName = serviceInterface.getSimpleName();
        beanFactory.registerBeanDefinition(serviceInterfaceBeanName, (BeanDefinition)beanDef);
        return (RpcProxyFactoryBean)((Object)beanFactory.getBean("&" + serviceInterfaceBeanName, RpcProxyFactoryBean.class));
    }

    @Override
    public Object annotationAtMethod(Annotation t, Object bean, String beanName, PropertyValues pvs, DefaultListableBeanFactory beanFactory, Method method) throws BeansException {
        if (t instanceof RpcProxy) {
            try {
                LOGGER.info((Object)("Annotation 'BrpcProxy' on method '" + method.getName() + "' for target '" + beanName + "' created"));
                return this.parseRpcProxyAnnotation((RpcProxy)t, method.getParameterTypes()[0], beanFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> getTypeAnnotation() {
        return RpcExporter.class;
    }

    @Override
    public List<Class<? extends Annotation>> getMethodFieldAnnotation() {
        ArrayList<Class<? extends Annotation>> list = new ArrayList<Class<? extends Annotation>>();
        list.add(RpcProxy.class);
        return list;
    }

    @Override
    public void destroy() throws Exception {
        if (this.rpcClients != null) {
            for (RpcProxyFactoryBean bean : this.rpcClients) {
                try {
                    bean.destroy();
                }
                catch (Exception e) {
                    LOGGER.fatal((Object)e.getMessage(), e.getCause());
                }
            }
        }
        if (this.portMappingExporters != null) {
            Collection<RpcServiceExporter> exporters = this.portMappingExporters.values();
            for (RpcServiceExporter rpcServiceExporter : exporters) {
                try {
                    rpcServiceExporter.destroy();
                }
                catch (Exception e) {
                    LOGGER.fatal((Object)e.getMessage(), e.getCause());
                }
            }
        }
        if (this.protobufRpcAnnotationResolverListener != null) {
            this.protobufRpcAnnotationResolverListener.destroy();
        }
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compiler != null) {
            JDKCompilerHelper.setCompiler((Compiler)this.compiler);
        }
    }

    public void setRpcClients(List<RpcProxyFactoryBean> rpcClients) {
        this.rpcClients = rpcClients;
    }

    public void setPortMappingExporters(Map<Integer, RpcServiceExporter> portMappingExporters) {
        this.portMappingExporters = portMappingExporters;
    }

    public void setNamingServiceUrl(String namingServiceUrl) {
        this.namingServiceUrl = namingServiceUrl;
    }

    public void setNamingServiceFactory(NamingServiceFactory namingServiceFactory) {
        this.namingServiceFactory = namingServiceFactory;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setProtobufRpcAnnotationResolverListener(RpcAnnotationResolverListener protobufRpcAnnotationResolverListener) {
        this.protobufRpcAnnotationResolverListener = protobufRpcAnnotationResolverListener;
    }

    public List<RpcProxyFactoryBean> getRpcClients() {
        return this.rpcClients;
    }

    public Map<Integer, RpcServiceExporter> getPortMappingExporters() {
        return this.portMappingExporters;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public String getNamingServiceUrl() {
        return this.namingServiceUrl;
    }

    public NamingServiceFactory getNamingServiceFactory() {
        return this.namingServiceFactory;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public RpcAnnotationResolverListener getProtobufRpcAnnotationResolverListener() {
        return this.protobufRpcAnnotationResolverListener;
    }
}

