/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

public class BoundedQueue<E>
implements Queue<E> {
    private int capacity;
    private int size;
    private ArrayDeque<E> queue;

    public BoundedQueue(int capacity) {
        this.capacity = capacity;
        this.size = 0;
        this.queue = new ArrayDeque(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isFull() {
        return this.size == this.capacity;
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.isFull()) {
            this.queue.pollFirst();
            --this.size;
        }
        this.queue.addLast(e);
        ++this.size;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int inputSize = c.size();
        if (inputSize > this.capacity) {
            throw new IllegalArgumentException("Size of added which is " + inputSize + " is larger than capacity=" + this.capacity);
        }
        int toPop = Math.max(0, inputSize - this.remainingCapacity());
        for (int i = 0; i < toPop; ++i) {
            this.queue.pollFirst();
        }
        this.size -= toPop;
        for (E e : c) {
            this.queue.addLast(e);
        }
        this.size += inputSize;
        return true;
    }

    public boolean addAll(E[] c, int offset, int len) {
        if (len > this.capacity) {
            throw new IllegalArgumentException("Size of added which is " + len + " is larger than capacity=" + this.capacity);
        }
        int toPop = Math.max(0, len - this.remainingCapacity());
        for (int i = 0; i < toPop; ++i) {
            this.queue.pollFirst();
        }
        this.size -= toPop;
        int last = offset + len;
        for (int i = offset; i < last; ++i) {
            this.queue.addLast(c[i]);
        }
        this.size += len;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = this.queue.removeAll(c);
        if (modified) {
            this.size = this.queue.size();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = this.queue.retainAll(c);
        if (modified) {
            this.size = this.queue.size();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.size = 0;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.queue.remove(o)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public E remove() {
        E e = this.queue.removeFirst();
        --this.size;
        return e;
    }

    @Override
    public E poll() {
        E e = this.queue.pollFirst();
        if (e != null) {
            --this.size;
        }
        return e;
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peekFirst();
    }

    public int remainingCapacity() {
        return this.capacity - this.size;
    }

    public E pop() {
        E e = this.queue.pop();
        --this.size;
        return e;
    }
}

