/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.standard;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.compress.Compress;
import com.baidu.brpc.compress.CompressManager;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.standard.BaiduRpcDecodePacket;
import com.baidu.brpc.protocol.standard.BaiduRpcEncodePacket;
import com.baidu.brpc.protocol.standard.BaiduRpcProto;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.ProtobufUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduRpcProtocol
extends AbstractProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(BaiduRpcProtocol.class);
    private static final byte[] MAGIC_HEAD = "PRPC".getBytes();
    private static final int FIXED_LEN = 12;
    private static final BaiduRpcProto.RpcMeta defaultRpcMetaInstance = BaiduRpcProto.RpcMeta.getDefaultInstance();
    private static final CompressManager compressManager = CompressManager.getInstance();
    private static final ServiceManager serviceManager = ServiceManager.getInstance();

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        BaiduRpcEncodePacket packet = new BaiduRpcEncodePacket();
        BaiduRpcProto.RpcMeta.Builder metaBuilder = BaiduRpcProto.RpcMeta.newBuilder();
        metaBuilder.setCorrelationId(request.getCorrelationId());
        int compressType = request.getCompressType();
        metaBuilder.setCompressType(request.getCompressType());
        BaiduRpcProto.RpcRequestMeta.Builder requestMeta = BaiduRpcProto.RpcRequestMeta.newBuilder();
        requestMeta.setLogId(request.getLogId());
        requestMeta.setServiceName(request.getServiceName());
        requestMeta.setMethodName(request.getMethodName());
        if (request.getTraceId() != null) {
            requestMeta.setTraceId(request.getTraceId());
        }
        if (request.getSpanId() != null) {
            requestMeta.setSpanId(request.getSpanId());
        }
        if (request.getParentSpanId() != null) {
            requestMeta.setSpanId(request.getParentSpanId());
        }
        if (request.getKvAttachment() != null) {
            for (Map.Entry<String, Object> kv : request.getKvAttachment().entrySet()) {
                requestMeta.addExtFieldsBuilder().setKey(kv.getKey()).setValue((String)kv.getValue());
            }
        }
        metaBuilder.setRequest(requestMeta.build());
        Compress compress = compressManager.getCompress(compressType);
        ByteBuf protoBuf = compress.compressInput(request.getArgs()[0], request.getRpcMethodInfo());
        packet.setProto(protoBuf);
        if (request.getBinaryAttachment() != null && request.getBinaryAttachment().isReadable()) {
            packet.setAttachment(request.getBinaryAttachment());
            metaBuilder.setAttachmentSize(request.getBinaryAttachment().readableBytes());
        }
        if (request.getAuth() != null) {
            metaBuilder.setAuthenticationData(ByteString.copyFrom((byte[])request.getAuth().getBytes()));
        }
        packet.setRpcMeta(metaBuilder.build());
        return this.encode(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcResponse decodeResponse(Object packet, ChannelHandlerContext ctx) throws Exception {
        BaiduRpcDecodePacket responsePacket = (BaiduRpcDecodePacket)packet;
        ByteBuf metaBuf = responsePacket.getMetaBuf();
        ByteBuf protoAndAttachmentBuf = responsePacket.getProtoAndAttachmentBuf();
        try {
            BaiduRpcProto.RpcMeta rpcMeta = (BaiduRpcProto.RpcMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcMetaInstance);
            RpcResponse rpcResponse = new RpcResponse();
            long correlationId = rpcMeta.getCorrelationId();
            rpcResponse.setCorrelationId(correlationId);
            ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
            RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
            if (future == null) {
                RpcResponse rpcResponse2 = rpcResponse;
                return rpcResponse2;
            }
            rpcResponse.setRpcFuture(future);
            BaiduRpcProto.RpcResponseMeta responseMeta = rpcMeta.getResponse();
            try {
                if (responseMeta != null && responseMeta.getErrorCode() == 0) {
                    Compress compress = compressManager.getCompress(rpcMeta.getCompressType());
                    int protoSize = protoAndAttachmentBuf.readableBytes() - rpcMeta.getAttachmentSize();
                    ByteBuf protoBuf = protoAndAttachmentBuf.readSlice(protoSize);
                    Object proto = compress.uncompressOutput(protoBuf, future.getRpcMethodInfo());
                    rpcResponse.setResult(proto);
                    if (rpcMeta.getAttachmentSize() > 0) {
                        rpcResponse.setBinaryAttachment(protoAndAttachmentBuf);
                        protoAndAttachmentBuf = null;
                    }
                } else {
                    rpcResponse.setException(new RpcException(3, responseMeta.getErrorText()));
                }
            }
            catch (Exception ex) {
                throw new RpcException(5, "decode response failed", ex);
            }
            RpcResponse rpcResponse3 = rpcResponse;
            return rpcResponse3;
        }
        finally {
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (protoAndAttachmentBuf != null) {
                protoAndAttachmentBuf.release();
            }
        }
    }

    @Override
    public BaiduRpcDecodePacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 12) {
            throw notEnoughDataException;
        }
        ByteBuf fixHeaderBuf = in.retainedSlice(12);
        try {
            byte[] magic = new byte[4];
            fixHeaderBuf.readBytes(magic);
            if (!Arrays.equals(magic, MAGIC_HEAD)) {
                throw new BadSchemaException("not valid magic head for brpc");
            }
            int bodySize = fixHeaderBuf.readInt();
            if (bodySize > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodySize);
            }
            if (in.readableBytes() < 12 + bodySize) {
                throw notEnoughDataException;
            }
            int metaSize = fixHeaderBuf.readInt();
            in.skipBytes(12);
            BaiduRpcDecodePacket packet = new BaiduRpcDecodePacket();
            try {
                ByteBuf metaBuf = in.readRetainedSlice(metaSize);
                packet.setMetaBuf(metaBuf);
                ByteBuf protoAndAttachmentBuf = in.readRetainedSlice(bodySize - metaSize);
                packet.setProtoAndAttachmentBuf(protoAndAttachmentBuf);
                BaiduRpcDecodePacket baiduRpcDecodePacket = packet;
                return baiduRpcDecodePacket;
            }
            catch (Exception ex) {
                LOG.warn("decode failed:", (Throwable)ex);
                throw new RpcException(5, (Throwable)ex);
            }
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.createRequest();
        BaiduRpcDecodePacket requestPacket = (BaiduRpcDecodePacket)packet;
        ByteBuf metaBuf = requestPacket.getMetaBuf();
        ByteBuf protoAndAttachmentBuf = requestPacket.getProtoAndAttachmentBuf();
        try {
            BaiduRpcProto.RpcMeta rpcMeta = (BaiduRpcProto.RpcMeta)ProtobufUtils.parseFrom(metaBuf, (Message)defaultRpcMetaInstance);
            BaiduRpcProto.RpcRequestMeta requestMeta = rpcMeta.getRequest();
            request.setCorrelationId(rpcMeta.getCorrelationId());
            int compressType = rpcMeta.getCompressType();
            request.setCompressType(compressType);
            request.setLogId(requestMeta.getLogId());
            RpcMethodInfo rpcMethodInfo = serviceManager.getService(requestMeta.getServiceName(), requestMeta.getMethodName());
            if (rpcMethodInfo == null) {
                String errorMsg = String.format("Fail to find service=%s, method=%s", requestMeta.getServiceName(), requestMeta.getMethodName());
                LOG.error(errorMsg);
                request.setException(new RpcException(3, errorMsg));
                Request request2 = request;
                return request2;
            }
            if (requestMeta.hasTraceId()) {
                request.setTraceId(requestMeta.getTraceId());
            }
            if (requestMeta.hasSpanId()) {
                request.setSpanId(request.getSpanId());
            }
            if (requestMeta.hasParentSpanId()) {
                request.setParentSpanId(requestMeta.getParentSpanId());
            }
            if (requestMeta.getExtFieldsCount() > 0) {
                if (request.getKvAttachment() == null) {
                    request.setKvAttachment(new HashMap<String, Object>());
                }
                for (BaiduRpcProto.RpcRequestMetaExtField extField : requestMeta.getExtFieldsList()) {
                    request.getKvAttachment().put(extField.getKey(), extField.getValue());
                }
            }
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setTarget(rpcMethodInfo.getTarget());
            if (rpcMeta.getAuthenticationData() != null) {
                request.setAuth(new String(rpcMeta.getAuthenticationData().toByteArray()));
            }
            Compress compress = compressManager.getCompress(compressType);
            if (rpcMeta.hasAttachmentSize() && rpcMeta.getAttachmentSize() > 0) {
                int protoSize = protoAndAttachmentBuf.readableBytes() - rpcMeta.getAttachmentSize();
                ByteBuf protoBuf = protoAndAttachmentBuf.readSlice(protoSize);
                Object proto = compress.uncompressInput(protoBuf, rpcMethodInfo);
                request.setArgs(new Object[]{proto});
                request.setBinaryAttachment(protoAndAttachmentBuf);
                protoAndAttachmentBuf = null;
            } else {
                Object proto = compress.uncompressInput(protoAndAttachmentBuf, rpcMethodInfo);
                request.setArgs(new Object[]{proto});
            }
            Request request3 = request;
            return request3;
        }
        finally {
            if (metaBuf != null) {
                metaBuf.release();
            }
            if (protoAndAttachmentBuf != null) {
                protoAndAttachmentBuf.release();
            }
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        BaiduRpcEncodePacket responsePacket = new BaiduRpcEncodePacket();
        BaiduRpcProto.RpcMeta.Builder metaBuilder = BaiduRpcProto.RpcMeta.newBuilder();
        metaBuilder.setCorrelationId(response.getCorrelationId());
        int compressType = response.getCompressType();
        metaBuilder.setCompressType(compressType);
        BaiduRpcProto.RpcResponseMeta.Builder responseMetaBuilder = BaiduRpcProto.RpcResponseMeta.newBuilder();
        if (response.getException() != null) {
            responseMetaBuilder.setErrorCode(2001);
            if (StringUtils.isNotBlank((CharSequence)response.getException().getMessage())) {
                responseMetaBuilder.setErrorText(response.getException().getMessage());
            }
            metaBuilder.setResponse(responseMetaBuilder.build());
            responsePacket.setRpcMeta(metaBuilder.build());
        } else {
            responseMetaBuilder.setErrorCode(0);
            metaBuilder.setResponse(responseMetaBuilder.build());
            Object responseProto = response.getResult();
            Compress compress = compressManager.getCompress(compressType);
            ByteBuf protoBuf = compress.compressOutput(responseProto, response.getRpcMethodInfo());
            responsePacket.setProto(protoBuf);
            if (response.getBinaryAttachment() != null) {
                responsePacket.setAttachment(response.getBinaryAttachment());
                metaBuilder.setAttachmentSize(response.getBinaryAttachment().readableBytes());
            }
            responsePacket.setRpcMeta(metaBuilder.build());
        }
        return this.encode(responsePacket);
    }

    protected ByteBuf encode(BaiduRpcEncodePacket packet) throws Exception {
        ByteBuf attachmentBuf;
        byte[] metaBytes = packet.getRpcMeta().toByteArray();
        ByteBuf metaBuf = Unpooled.wrappedBuffer((byte[])metaBytes);
        int metaSize = metaBytes.length;
        ByteBuf headerBuf = Unpooled.buffer((int)12);
        headerBuf.writeBytes(MAGIC_HEAD);
        int bodySize = metaSize;
        ByteBuf protoBuf = packet.getProto();
        if (protoBuf != null) {
            bodySize += protoBuf.readableBytes();
        }
        if ((attachmentBuf = packet.getAttachment()) != null) {
            bodySize += attachmentBuf.readableBytes();
        }
        headerBuf.writeInt(bodySize);
        headerBuf.writeInt(metaSize);
        if (protoBuf != null && attachmentBuf != null) {
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, metaBuf, protoBuf, attachmentBuf});
        }
        if (protoBuf != null) {
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, metaBuf, protoBuf});
        }
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, metaBuf});
    }

    @Override
    public boolean isCoexistence() {
        return true;
    }
}

