/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.RpcTimeoutTimer;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.BrpcChannelFactory;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.client.channel.ServiceInstance;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.ClientInvokeInterceptor;
import com.baidu.brpc.interceptor.ClientTraceInterceptor;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.thread.TimerInstance;
import com.baidu.brpc.utils.CollectionUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationClient {
    private static final Logger log = LoggerFactory.getLogger(CommunicationClient.class);
    protected ServiceInstance serviceInstance;
    protected CommunicationOptions communicationOptions;
    protected BrpcChannel brpcChannel;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private AtomicBoolean stop = new AtomicBoolean(false);

    public CommunicationClient(ServiceInstance serviceInstance, CommunicationOptions communicationOptions, List<Interceptor> interceptors) {
        this.serviceInstance = serviceInstance;
        this.communicationOptions = communicationOptions.clone();
        this.brpcChannel = BrpcChannelFactory.createChannel(serviceInstance, this.communicationOptions);
        if (CollectionUtils.isNotEmpty(interceptors)) {
            this.interceptors.addAll(interceptors);
        }
        this.interceptors.add(new ClientTraceInterceptor());
        this.interceptors.add(new ClientInvokeInterceptor(this));
    }

    public void execute(Request request, Response response) throws RpcException {
        request.setCommunicationClient(this);
        Channel channel = this.selectChannel();
        request.setChannel(channel);
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(channel);
        RpcFuture rpcFuture = RpcFuture.createRpcFuture(request);
        if (request.getCallback() != null) {
            rpcFuture.setInterceptors(this.interceptors);
        }
        channelInfo.setCorrelationId(rpcFuture.getCorrelationId());
        rpcFuture.setChannelInfo(channelInfo);
        rpcFuture.setChannelType(this.communicationOptions.getChannelType());
        request.setRpcFuture(rpcFuture);
        request.setCorrelationId(rpcFuture.getCorrelationId());
        try {
            request.setSendBuf(this.communicationOptions.getProtocol().encodeRequest(request));
        }
        catch (Throwable t) {
            throw new RpcException(5, t.getMessage(), t);
        }
        Timer timeoutTimer = TimerInstance.getInstance();
        RpcTimeoutTimer timeoutTask = new RpcTimeoutTimer(channelInfo, request.getCorrelationId(), this.communicationOptions.getProtocol());
        Timeout timeout = timeoutTimer.newTimeout((TimerTask)timeoutTask, (long)request.getReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
        request.getRpcFuture().setTimeout(timeout);
        try {
            request.retain();
            ChannelFuture sendFuture = request.getChannel().writeAndFlush((Object)request.getSendBuf());
            sendFuture.awaitUninterruptibly((long)request.getWriteTimeoutMillis().intValue());
            if (!sendFuture.isSuccess()) {
                if (!(sendFuture.cause() instanceof ClosedChannelException)) {
                    log.warn("send request failed, channelActive={}, ex={}", (Object)request.getChannel().isActive(), (Object)sendFuture.cause());
                }
                String errMsg = String.format("send request failed, channelActive=%b", request.getChannel().isActive());
                throw new RpcException(1, errMsg);
            }
        }
        catch (Exception ex) {
            channelInfo.handleRequestFail(this.communicationOptions.getChannelType(), request.getCorrelationId());
            timeout.cancel();
            log.debug("send request failed:", (Throwable)ex);
            if (ex instanceof RpcException) {
                throw (RpcException)ex;
            }
            throw new RpcException(1, "send request failed", ex);
        }
        channelInfo.handleRequestSuccess(this.communicationOptions.getChannelType());
        if (rpcFuture.isAsync()) {
            response.setRpcFuture(rpcFuture);
        } else {
            response.setResult(rpcFuture.get(request.getReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS));
            response.setCorrelationId(rpcFuture.getCorrelationId());
        }
    }

    public void executeChain(Request request, Response response) throws RpcException {
        this.execute(request, response);
    }

    public Channel selectChannel() {
        Channel channel;
        try {
            channel = this.brpcChannel.getChannel();
        }
        catch (NoSuchElementException full) {
            int maxConnections = this.brpcChannel.getCurrentMaxConnection() * 2;
            this.brpcChannel.updateMaxConnection(maxConnections);
            String errMsg = String.format("channel pool is exhausted, and double maxTotalConnection,server=%s:%d", this.brpcChannel.getServiceInstance().getIp(), this.brpcChannel.getServiceInstance().getPort());
            log.debug(errMsg);
            throw new RpcException(1, errMsg, full);
        }
        catch (IllegalStateException illegalState) {
            String errMsg = String.format("channel pool is closed, server=%s:%d", this.brpcChannel.getServiceInstance().getIp(), this.brpcChannel.getServiceInstance().getPort());
            log.debug(errMsg);
            throw new RpcException(0, errMsg, illegalState);
        }
        catch (Exception connectedFailed) {
            String errMsg = this.communicationOptions.getChannelType() == ChannelType.POOLED_CONNECTION ? String.format("channel pool make new object failed, active=%d,idle=%d,server=%s:%d, ex=%s", this.brpcChannel.getActiveConnectionNum(), this.brpcChannel.getIdleConnectionNum(), this.brpcChannel.getServiceInstance().getIp(), this.brpcChannel.getServiceInstance().getPort(), connectedFailed.getMessage()) : String.format("get channel failed, ex=%s", connectedFailed.getMessage());
            log.debug(errMsg);
            throw new RpcException(0, errMsg, connectedFailed);
        }
        if (channel == null) {
            String errMsg = "channel is null, retry another channel";
            log.debug(errMsg);
            throw new RpcException(0, errMsg);
        }
        if (!channel.isActive()) {
            this.brpcChannel.incFailedNum();
            this.brpcChannel.removeChannel(channel);
            String errMsg = "channel is non active, retry another channel";
            throw new RpcException(1, errMsg);
        }
        return channel;
    }

    public void stop() {
        if (this.stop.compareAndSet(false, true) && this.brpcChannel != null) {
            this.brpcChannel.close();
        }
    }

    public boolean equals(Object object) {
        boolean flag = false;
        if (object != null && CommunicationClient.class.isAssignableFrom(object.getClass())) {
            CommunicationClient rhs = (CommunicationClient)object;
            flag = new EqualsBuilder().append((Object)this.serviceInstance, (Object)rhs.serviceInstance).isEquals();
        }
        return flag;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.serviceInstance).toHashCode();
    }

    public String toString() {
        return this.serviceInstance.toString();
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    public CommunicationOptions getCommunicationOptions() {
        return this.communicationOptions;
    }

    public BrpcChannel getBrpcChannel() {
        return this.brpcChannel;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }
}

