/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.http;

import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.AipResponse;
import com.baidu.aip.util.ExceptionUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AipHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AipHttpClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AipResponse post(AipRequest request) {
        String charset = request.getContentEncoding();
        String content = request.getBodyStr();
        HashMap<String, String> header = request.getHeaders();
        AipResponse response = new AipResponse();
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            String url = request.getParams().isEmpty() ? request.getUri().toString() : String.format("%s?%s", request.getUri().toString(), request.getParamStr());
            URL console = new URL(url);
            Proxy proxy = request.getConfig() == null ? Proxy.NO_PROXY : request.getConfig().getProxy();
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(proxy);
            if (request.getConfig() != null) {
                conn.setConnectTimeout(request.getConfig().getConnectionTimeoutMillis());
                conn.setReadTimeout(request.getConfig().getSocketTimeoutMillis());
            }
            conn.setDoOutput(true);
            for (Map.Entry<String, String> aipResponse : header.entrySet()) {
                conn.setRequestProperty(aipResponse.getKey(), aipResponse.getValue());
            }
            conn.connect();
            out = new DataOutputStream(conn.getOutputStream());
            out.write(content.getBytes(charset));
            ((DataOutputStream)out).flush();
            int statusCode = conn.getResponseCode();
            response.setHeader(conn.getHeaderFields());
            response.setStatus(statusCode);
            response.setCharset(charset);
            if (statusCode != 200) {
                AipResponse aipResponse = response;
                return aipResponse;
            }
            is = conn.getInputStream();
            if (is != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                response.setBody(byteArrayOutputStream.toByteArray());
            }
            AipResponse aipResponse = response;
            return aipResponse;
        }
        catch (Exception e) {
            response.setErrorMsg(ExceptionUtil.buildErrorMessage(e));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }
}

