/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.auth;

import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.AipClientConst;
import com.baidu.aip.util.SignUtil;
import com.baidu.aip.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class CloudAuth {
    public static String sign(AipRequest request, String ak, String sk, String timestamp) {
        HashMap<String, String> headers = request.getHeaders();
        HashMap<String, String> params = request.getParams();
        String httpMethod = request.getHttpMethod().toString();
        String path = request.getUri().getPath();
        String authStringPrefix = String.format("bce-auth-v1/%s/%s/%d", ak, timestamp, AipClientConst.BCE_AUTH_EXPIRE_IN_SECONDS);
        try {
            String signingKey = SignUtil.hmacSha256(sk, authStringPrefix);
            String canonicalUri = CloudAuth.getCanonicalUri(path);
            String canonicalQuery = CloudAuth.getCanonicalQuery(params);
            String canonicalHeaders = CloudAuth.getCanonicalHeaders(headers);
            ArrayList<String> canonicalRequest = new ArrayList<String>();
            canonicalRequest.add(httpMethod);
            canonicalRequest.add(canonicalUri);
            canonicalRequest.add(canonicalQuery);
            canonicalRequest.add(canonicalHeaders);
            String signature = SignUtil.hmacSha256(signingKey, Util.mkString(canonicalRequest.iterator(), '\n'));
            return String.format("%s/%s/%s", authStringPrefix, "", signature);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCanonicalUri(String path) {
        if (!path.startsWith("/")) {
            path = String.format("/%s", path);
        }
        return Util.uriEncode(path, false);
    }

    private static String getCanonicalQuery(HashMap<String, String> params) {
        if (params.isEmpty()) {
            return "";
        }
        TreeSet<String> querySet = new TreeSet<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey().toLowerCase().equals("authorization")) continue;
            querySet.add(String.format("%s=%s", Util.uriEncode(entry.getKey(), true), Util.uriEncode(entry.getValue(), true)));
        }
        return Util.mkString(querySet.iterator(), '&');
    }

    private static String getCanonicalHeaders(HashMap<String, String> headers) {
        if (headers.isEmpty()) {
            return "";
        }
        TreeSet<String> headerSet = new TreeSet<String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey().trim().toLowerCase();
            if (!key.startsWith("x-bce-") && !AipClientConst.BCE_HEADER_TO_SIGN.contains(key)) continue;
            headerSet.add(String.format("%s:%s", Util.uriEncode(key, true), Util.uriEncode(entry.getValue().trim(), true)));
        }
        return Util.mkString(headerSet.iterator(), '\n');
    }
}

