/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.grpc;

import com.baidu.acu.pie.AsrServiceGrpc;
import com.baidu.acu.pie.AudioStreaming;
import com.baidu.acu.pie.client.AsrClient;
import com.baidu.acu.pie.client.Consumer;
import com.baidu.acu.pie.exception.AsrClientException;
import com.baidu.acu.pie.exception.AsrException;
import com.baidu.acu.pie.model.AsrConfig;
import com.baidu.acu.pie.model.ChannelConfig;
import com.baidu.acu.pie.model.FinishLatchImpl;
import com.baidu.acu.pie.model.RecognitionResult;
import com.baidu.acu.pie.model.RequestMetaData;
import com.baidu.acu.pie.model.StreamContext;
import com.baidu.acu.pie.util.Base64;
import com.baidu.acu.pie.util.DateTimeParser;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.internal.IoUtils;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsrClientGrpcImpl
implements AsrClient {
    private static final Logger log = LoggerFactory.getLogger(AsrClientGrpcImpl.class);
    private final ManagedChannel managedChannel;
    private final AsrServiceGrpc.AsrServiceStub asyncStub;
    private AsrConfig asrConfig;

    public AsrClientGrpcImpl(AsrConfig asrConfig) {
        this(asrConfig, ChannelConfig.builder().build());
    }

    public AsrClientGrpcImpl(AsrConfig asrConfig, ChannelConfig channelConfig) {
        this.asrConfig = asrConfig;
        this.managedChannel = asrConfig.isSslUseFlag() ? this.initSslManagedChannel(asrConfig, channelConfig) : this.initManagedChannel(asrConfig, channelConfig);
        this.asyncStub = AsrServiceGrpc.newStub((Channel)this.managedChannel);
    }

    @Override
    public void shutdown() {
        try {
            this.managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("shutdown failed: ", (Throwable)e);
        }
    }

    @Override
    public int getFragmentSize() {
        return this.getFragmentSize(new RequestMetaData());
    }

    @Override
    public int getFragmentSize(RequestMetaData requestMetaData) {
        return (int)((double)this.asrConfig.getProduct().getSampleRate() * requestMetaData.getSendPackageRatio() * requestMetaData.getSendPerSeconds() * 2.0);
    }

    @Override
    public List<RecognitionResult> syncRecognize(File audioFile) {
        return this.syncRecognize(audioFile, new RequestMetaData());
    }

    @Override
    public List<RecognitionResult> syncRecognize(File audioFile, RequestMetaData requestMetaData) {
        log.info("start to recognition, file: {}", (Object)audioFile.getAbsoluteFile().getName());
        try {
            byte[] data = Files.readAllBytes(audioFile.toPath());
            return this.syncRecognize(data, requestMetaData);
        }
        catch (IOException e) {
            log.error("fail to read file", (Throwable)e);
            throw new AsrClientException("fail to read file");
        }
    }

    @Override
    public List<RecognitionResult> syncRecognize(InputStream inputStream) {
        return this.syncRecognize(inputStream, new RequestMetaData());
    }

    @Override
    public List<RecognitionResult> syncRecognize(InputStream inputStream, RequestMetaData requestMetaData) {
        try {
            byte[] data = IoUtils.toByteArray((InputStream)inputStream);
            return this.syncRecognize(data, requestMetaData);
        }
        catch (IOException e) {
            log.error("fail to read input stream", (Throwable)e);
            throw new AsrClientException("fail to read input stream");
        }
    }

    @Override
    public List<RecognitionResult> syncRecognize(final byte[] data, RequestMetaData requestMetaData) {
        final ArrayList<RecognitionResult> results = new ArrayList<RecognitionResult>();
        final StreamContext streamContext = this.asyncRecognize(new Consumer<RecognitionResult>(){

            @Override
            public void accept(RecognitionResult recognitionResult) {
                results.add(recognitionResult);
            }
        }, requestMetaData);
        double sleepRatio = requestMetaData.getSleepRatio();
        if (sleepRatio == 0.0) {
            streamContext.send(data);
        } else {
            final CountDownLatch sendFinishLatch = new CountDownLatch(1);
            final AtomicInteger offset = new AtomicInteger(0);
            final int fragmentSize = streamContext.getFragmentSize();
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (offset.get() < data.length && !streamContext.getFinishLatch().finished()) {
                        streamContext.send(Arrays.copyOfRange(data, offset.get(), Math.min(offset.addAndGet(fragmentSize), data.length)));
                    } else {
                        sendFinishLatch.countDown();
                    }
                }
            }, 0L, (long)(sleepRatio * requestMetaData.getSendPerSeconds() * 1000.0));
            sendFinishLatch.await();
            timer.cancel();
        }
        streamContext.complete();
        if (!streamContext.await(requestMetaData.getTimeoutMinutes(), TimeUnit.MINUTES)) {
            log.error("Recognition request not finish within {} minutes, maybe the audio is too large", (Object)requestMetaData.getTimeoutMinutes());
        }
        log.info("finish recognition request");
        return results;
    }

    @Override
    public StreamContext asyncRecognize(Consumer<RecognitionResult> resultConsumer) {
        return this.asyncRecognize(resultConsumer, new RequestMetaData());
    }

    @Override
    public StreamContext asyncRecognize(final Consumer<RecognitionResult> resultConsumer, RequestMetaData requestMetaData) {
        final FinishLatchImpl finishLatch = new FinishLatchImpl();
        AsrServiceGrpc.AsrServiceStub stubWithMetadata = (AsrServiceGrpc.AsrServiceStub)MetadataUtils.attachHeaders((AbstractStub)this.asyncStub, (Metadata)this.prepareMetadata(requestMetaData));
        return StreamContext.builder().sender(stubWithMetadata.send(new StreamObserver<AudioStreaming.AudioFragmentResponse>(){

            public void onNext(AudioStreaming.AudioFragmentResponse response) {
                if (response.getErrorCode() == 0) {
                    resultConsumer.accept(AsrClientGrpcImpl.this.fromAudioFragmentResponse(response.getErrorMessage(), response.getAudioFragment()));
                } else {
                    finishLatch.fail(new AsrException(response.getTraceId(), response.getErrorCode(), response.getErrorMessage()));
                }
            }

            public void onError(Throwable t) {
                finishLatch.fail(new AsrException(-2000, "error in grpc response observer", t));
            }

            public void onCompleted() {
                log.info("response observer complete");
                finishLatch.finish();
            }
        })).finishLatch(finishLatch).fragmentSize(this.getFragmentSize(requestMetaData)).build();
    }

    private ManagedChannel initManagedChannel(AsrConfig asrConfig, ChannelConfig channelConfig) {
        return ManagedChannelBuilder.forAddress((String)asrConfig.getServerIp(), (int)asrConfig.getServerPort()).usePlaintext().keepAliveTime(channelConfig.getKeepAliveTime().getTime(), channelConfig.getKeepAliveTime().getTimeUnit()).keepAliveTimeout(channelConfig.getKeepAliveTimeout().getTime(), channelConfig.getKeepAliveTimeout().getTimeUnit()).build();
    }

    private ManagedChannel initSslManagedChannel(AsrConfig asrConfig, ChannelConfig channelConfig) {
        try {
            return NettyChannelBuilder.forAddress((String)asrConfig.getServerIp(), (int)asrConfig.getServerPort()).keepAliveTime(channelConfig.getKeepAliveTime().getTime(), channelConfig.getKeepAliveTime().getTimeUnit()).keepAliveTimeout(channelConfig.getKeepAliveTimeout().getTime(), channelConfig.getKeepAliveTimeout().getTimeUnit()).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().trustManager(new File(asrConfig.getSslPath())).build()).build();
        }
        catch (SSLException e) {
            throw new AsrClientException("build ssl client failed");
        }
    }

    private Metadata prepareMetadata(RequestMetaData requestMetaData) {
        String digestedToken;
        String expireDateTime;
        if (Strings.isNullOrEmpty((String)this.asrConfig.getToken())) {
            expireDateTime = DateTimeParser.toUTCString(DateTime.now().plusMinutes(30));
            String rawToken = this.asrConfig.getUserName() + this.asrConfig.getPassword() + expireDateTime;
            digestedToken = Hashing.sha256().hashString((CharSequence)rawToken, StandardCharsets.UTF_8).toString();
        } else {
            if (this.asrConfig.getExpireDateTime() == null) {
                throw new AsrClientException("Neither `token` nor `expireDateTime` should be Null");
            }
            expireDateTime = DateTimeParser.toUTCString(this.asrConfig.getExpireDateTime());
            digestedToken = this.asrConfig.getToken();
        }
        AudioStreaming.InitRequest initRequest = AudioStreaming.InitRequest.newBuilder().setEnableLongSpeech(true).setEnableChunk(true).setEnableFlushData(requestMetaData.isEnableFlushData()).setProductId(this.asrConfig.getProduct().getCode()).setSamplePointBytes(2).setSendPerSeconds(requestMetaData.getSendPerSeconds()).setSleepRatio(requestMetaData.getSleepRatio()).setAppName(this.asrConfig.getAppName()).setLogLevel(this.asrConfig.getLogLevel().getCode()).setUserName(this.asrConfig.getUserName()).setExpireTime(expireDateTime).setToken(digestedToken).setVersion(AudioStreaming.ProtoVersion.VERSION_1).setExtraInfo(requestMetaData.getExtraInfo()).build();
        Metadata headers = new Metadata();
        String meta_string = Base64.encode(initRequest.toByteArray());
        headers.put(Metadata.Key.of((String)"audio_meta", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)meta_string);
        log.info("init request: \n{}meta_string: {}", (Object)initRequest.toString(), (Object)meta_string);
        return headers;
    }

    private RecognitionResult fromAudioFragmentResponse(String traceId, AudioStreaming.AudioFragmentResult response) {
        return RecognitionResult.builder().traceId(traceId).serialNum(response.getSerialNum()).startTime(DateTimeParser.parseLocalTime(response.getStartTime())).endTime(DateTimeParser.parseLocalTime(response.getEndTime())).result(response.getResult()).completed(response.getCompleted()).build();
    }
}

