/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils.lock;

import com.badoo.reaktive.utils.lock.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/badoo/reaktive/utils/lock/Lock;", "", "()V", "delegate", "Ljava/util/concurrent/locks/ReentrantLock;", "acquire", "", "destroy", "newCondition", "Lcom/badoo/reaktive/utils/lock/Condition;", "release", "ConditionImpl", "utils_release"})
public final class Lock {
    @NotNull
    private final ReentrantLock delegate = new ReentrantLock();

    public final void acquire() {
        this.delegate.lock();
    }

    public final void release() {
        this.delegate.unlock();
    }

    public final void destroy() {
    }

    @NotNull
    public final Condition newCondition() {
        java.util.concurrent.locks.Condition condition = this.delegate.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"this@Lock.delegate.newCondition()");
        return new ConditionImpl(condition);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/badoo/reaktive/utils/lock/Lock$ConditionImpl;", "Lcom/badoo/reaktive/utils/lock/Condition;", "delegate", "Ljava/util/concurrent/locks/Condition;", "(Ljava/util/concurrent/locks/Condition;)V", "await", "", "timeoutNanos", "", "destroy", "signal", "utils_release"})
    private static final class ConditionImpl
    implements Condition {
        @NotNull
        private final java.util.concurrent.locks.Condition delegate;

        public ConditionImpl(@NotNull java.util.concurrent.locks.Condition delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await(long timeoutNanos) {
            boolean isInterrupted = Thread.interrupted();
            try {
                if (timeoutNanos >= 0L) {
                    this.delegate.awaitNanos(timeoutNanos);
                } else {
                    this.delegate.await();
                }
                if (isInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (InterruptedException e) {
                try {
                    isInterrupted = true;
                }
                catch (Throwable throwable) {
                    if (isInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void signal() {
            this.delegate.signalAll();
        }

        @Override
        public void destroy() {
        }
    }
}

