/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils;

import com.badoo.reaktive.utils.CurrentThreadKt;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use custom solution with kotlin.native.concurrent.WorkerBoundReference")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0017B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0010J\r\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/badoo/reaktive/utils/ThreadLocalHolder;", "T", "", "initialValue", "(Ljava/lang/Object;)V", "_isDisposed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "isDisposed", "", "()Z", "key", "originalThreadId", "", "originalThreadName", "", "checkCurrentThread", "", "checkDisposed", "dispose", "get", "()Ljava/lang/Object;", "set", "value", "ThreadLocalState", "utils_debug"})
public class ThreadLocalHolder<T> {
    private final long originalThreadId;
    @NotNull
    private final String originalThreadName;
    @NotNull
    private final Object key;
    @NotNull
    private final AtomicBoolean _isDisposed;

    public ThreadLocalHolder(@Nullable T initialValue) {
        this.originalThreadId = CurrentThreadKt.getCurrentThreadId();
        this.originalThreadName = CurrentThreadKt.getCurrentThreadName();
        this.key = ThreadLocalState.INSTANCE.allocateKey();
        this._isDisposed = new AtomicBoolean(false, 1, null);
        if (initialValue != null) {
            this.set(initialValue);
        }
    }

    public /* synthetic */ ThreadLocalHolder(Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = null;
        }
        this(object);
    }

    public final boolean isDisposed() {
        this.checkCurrentThread();
        return this._isDisposed.getValue();
    }

    @Nullable
    public final T get() {
        this.checkCurrentThread();
        return (T)ThreadLocalState.INSTANCE.get(this.key);
    }

    public final void set(@Nullable T value) {
        this.checkCurrentThread();
        this.checkDisposed();
        ThreadLocalState.INSTANCE.set(this.key, value);
    }

    public final void dispose() {
        this.checkCurrentThread();
        if (this._isDisposed.compareAndSet(false, true)) {
            ThreadLocalState.INSTANCE.set(this.key, null);
        }
    }

    private final void checkCurrentThread() {
        long threadId = CurrentThreadKt.getCurrentThreadId();
        if (!(threadId == this.originalThreadId)) {
            boolean bl = false;
            String string = "Accessing ThreadLocalStorage from another threads is prohibited. Original thread was (" + this.originalThreadId + ", " + this.originalThreadName + "), actual thread is (" + threadId + ", " + CurrentThreadKt.getCurrentThreadName() + ").";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void checkDisposed() {
        if (!(!this._isDisposed.getValue())) {
            boolean bl = false;
            String string = "ThreadLocalStorage is already disposed";
            throw new IllegalStateException(string.toString());
        }
    }

    public ThreadLocalHolder() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0001J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0002J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/badoo/reaktive/utils/ThreadLocalHolder$ThreadLocalState;", "", "()V", "currentKey", "", "map", "", "allocateKey", "get", "key", "set", "", "value", "utils_debug"})
    private static final class ThreadLocalState {
        @NotNull
        public static final ThreadLocalState INSTANCE = new ThreadLocalState();
        @NotNull
        private static final Map<Object, Object> map = new HashMap();
        private static int currentKey;

        private ThreadLocalState() {
        }

        @NotNull
        public final Object allocateKey() {
            int n = currentKey;
            currentKey = n + 1;
            return n;
        }

        @Nullable
        public final Object get(@NotNull Object key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return map.get(key);
        }

        public final void set(@NotNull Object key, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                map.remove(key);
            } else {
                map.put(key, value);
            }
        }
    }
}

