/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.observable;

import com.badoo.reaktive.base.Emitter;
import com.badoo.reaktive.base.ErrorCallback;
import com.badoo.reaktive.base.Observer;
import com.badoo.reaktive.completable.Completable;
import com.badoo.reaktive.completable.CompletableObserver;
import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.disposable.SerialDisposable;
import com.badoo.reaktive.observable.Observable;
import com.badoo.reaktive.observable.ObservableEmitter;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.subject.unicast.UnicastSubject;
import com.badoo.reaktive.subject.unicast.UnicastSubjectBuilderKt;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import com.badoo.reaktive.utils.atomic.AtomicLong;
import com.badoo.reaktive.utils.atomic.AtomicReference;
import com.badoo.reaktive.utils.atomic.AtomicReferenceExtKt;
import com.badoo.reaktive.utils.queue.ArrayQueue;
import com.badoo.reaktive.utils.serializer.Serializer;
import com.badoo.reaktive.utils.serializer.SerializerImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0006,-./01BY\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u001b\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u00020\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010#H\u0002J\u0015\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\rH\u0002J\b\u0010(\u001a\u00020\rH\u0002J\u0015\u0010)\u001a\u00020\r2\u0006\u0010%\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0012\u0010+\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0002R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal;", "T", "S", "", "upstream", "Lcom/badoo/reaktive/observable/Observable;", "opening", "closing", "Lkotlin/Function1;", "Lcom/badoo/reaktive/completable/Completable;", "limit", "", "restartOnLimit", "", "emitter", "Lcom/badoo/reaktive/observable/ObservableEmitter;", "(Lcom/badoo/reaktive/observable/Observable;Lcom/badoo/reaktive/observable/Observable;Lkotlin/jvm/functions/Function1;JZLcom/badoo/reaktive/observable/ObservableEmitter;)V", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "openingObserver", "Lcom/badoo/reaktive/observable/WindowBySignal$OpeningObserver;", "upstreamObserver", "Lcom/badoo/reaktive/observable/WindowBySignal$UpstreamObserver;", "windows", "Lcom/badoo/reaktive/utils/atomic/AtomicReference;", "", "Lcom/badoo/reaktive/observable/WindowBySignal$ClosingObserver;", "onClose", "window", "onDownstreamDisposed", "onError", "error", "", "onEvent", "event", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "onOpen", "value", "(Ljava/lang/Object;)Z", "onOpeningCompleted", "onUpstreamCompleted", "onValue", "open", "processEvent", "AbstractObserver", "ClosingObserver", "Event", "OpeningObserver", "UpstreamObserver", "WindowWrapper", "reaktive_debug"})
final class WindowBySignal<T, S> {
    @NotNull
    private final Function1<S, Completable> closing;
    private final long limit;
    private final boolean restartOnLimit;
    @NotNull
    private final ObservableEmitter<Observable<? extends T>> emitter;
    @NotNull
    private final Serializer<Object> actor;
    @NotNull
    private final UpstreamObserver<T> upstreamObserver;
    @NotNull
    private final OpeningObserver<S> openingObserver;
    @NotNull
    private final AtomicReference<Set<ClosingObserver<T>>> windows;

    public WindowBySignal(@NotNull Observable<? extends T> upstream, @NotNull Observable<? extends S> opening, @NotNull Function1<? super S, ? extends Completable> closing, long limit, boolean restartOnLimit, @NotNull ObservableEmitter<? super Observable<? extends T>> emitter2) {
        Intrinsics.checkNotNullParameter(upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(closing, (String)"closing");
        Intrinsics.checkNotNullParameter(emitter2, (String)"emitter");
        this.closing = closing;
        this.limit = limit;
        this.restartOnLimit = restartOnLimit;
        this.emitter = emitter2;
        boolean $i$f$serializer = false;
        ArrayQueue arrayQueue = new ArrayQueue();
        this.actor = new SerializerImpl<Object>(arrayQueue, this){
            final /* synthetic */ WindowBySignal $receiver$inlined;
            {
                this.$receiver$inlined = windowBySignal;
                super($super_call_param$1);
            }

            public boolean onValue(Object value) {
                Object p0 = value;
                boolean bl = false;
                return WindowBySignal.access$processEvent(this.$receiver$inlined, p0);
            }
        };
        this.upstreamObserver = new UpstreamObserver(this.actor);
        this.openingObserver = new OpeningObserver(this.actor);
        this.windows = new AtomicReference((Object)SetsKt.emptySet());
        Emitter $this$setCancellable$iv = this.emitter;
        boolean $i$f$setCancellable = false;
        boolean $i$f$Disposable = false;
        $this$setCancellable$iv.setDisposable(new Disposable(this){
            final /* synthetic */ WindowBySignal this$0;
            {
                this.this$0 = windowBySignal;
            }

            public boolean isDisposed() {
                return this.get();
            }

            public void dispose() {
                if (this.compareAndSet(false, true)) {
                    boolean bl = false;
                    WindowBySignal.access$getActor$p(this.this$0).accept(Event.DownstreamDisposed.INSTANCE);
                }
            }
        });
        upstream.subscribe(this.upstreamObserver);
        opening.subscribe((Observer)this.openingObserver);
    }

    private final boolean processEvent(Object event) {
        return event instanceof Event ? this.onEvent((Event)event) : this.onValue(event);
    }

    private final boolean onEvent(Event<? extends T, ? extends S> event) {
        boolean bl;
        Event<? extends T, ? extends S> event2 = event;
        if (event2 instanceof Event.Open) {
            bl = this.onOpen(((Event.Open)event).getValue());
        } else if (event2 instanceof Event.Close) {
            bl = this.onClose(((Event.Close)event).getWindow());
        } else if (Intrinsics.areEqual(event2, (Object)Event.UpstreamCompleted.INSTANCE)) {
            bl = this.onUpstreamCompleted();
        } else if (Intrinsics.areEqual(event2, (Object)Event.OpeningCompleted.INSTANCE)) {
            bl = this.onOpeningCompleted();
        } else if (Intrinsics.areEqual(event2, (Object)Event.DownstreamDisposed.INSTANCE)) {
            bl = this.onDownstreamDisposed();
        } else if (event2 instanceof Event.Error) {
            bl = this.onError(((Event.Error)event).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean onOpen(S value) {
        Completable completable2;
        try {
            completable2 = (Completable)this.closing.invoke(value);
        }
        catch (Throwable e) {
            this.onError(e);
            return false;
        }
        Completable closing = completable2;
        return this.open(closing);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean open(Completable closing) {
        UnicastSubject window2 = UnicastSubjectBuilderKt.UnicastSubject$default(0, null, 3, null);
        WindowWrapper windowWrapper2 = new WindowWrapper(window2);
        this.emitter.onNext(windowWrapper2);
        if (windowWrapper2.isSubscribed().getValue()) {
            void it;
            Set set;
            Object object;
            AtomicReference<Set<ClosingObserver<T>>> atomicReference;
            ClosingObserver closingObserver = new ClosingObserver(this.actor, closing, window2);
            AtomicReference<Set<ClosingObserver<T>>> $this$update$iv = this.windows;
            boolean $i$f$update = false;
            AtomicReference<Set<ClosingObserver<T>>> $this$getAndUpdate$iv$iv = $this$update$iv;
            boolean $i$f$getAndUpdate = false;
            Object prev$iv$iv = null;
            do {
                prev$iv$iv = $this$getAndUpdate$iv$iv.getValue();
                Set set2 = (Set)prev$iv$iv;
                object = prev$iv$iv;
                atomicReference = $this$getAndUpdate$iv$iv;
                boolean bl = false;
            } while (!atomicReference.compareAndSet(object, (Object)(set = SetsKt.plus((Set)it, closingObserver))));
            try {
                closing.subscribe((Observer)closingObserver);
            }
            catch (Throwable e) {
                this.onError(e);
                return false;
            }
        } else {
            window2.onComplete();
        }
        return true;
    }

    private final boolean onClose(ClosingObserver<T> window2) {
        Set it;
        Object prev$iv;
        AtomicReference<Set<ClosingObserver<T>>> $this$updateAndGet$iv = this.windows;
        boolean $i$f$updateAndGet = false;
        Set next$iv = null;
        do {
            prev$iv = $this$updateAndGet$iv.getValue();
            it = (Set)prev$iv;
            boolean bl = false;
        } while (!$this$updateAndGet$iv.compareAndSet(prev$iv, (Object)(next$iv = SetsKt.minus((Set)it, window2))));
        int windowCount = next$iv.size();
        window2.getSubject().onComplete();
        if (windowCount == 0 && (this.upstreamObserver.isDone() || this.openingObserver.isDone())) {
            this.upstreamObserver.dispose();
            this.openingObserver.dispose();
            this.emitter.onComplete();
            return false;
        }
        return true;
    }

    private final boolean onUpstreamCompleted() {
        this.upstreamObserver.markCompleted();
        this.openingObserver.dispose();
        Iterable $this$forEach$iv = (Iterable)AtomicReferenceExtKt.getAndSet(this.windows, (Object)SetsKt.emptySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClosingObserver it = (ClosingObserver)element$iv;
            boolean bl = false;
            it.dispose();
            it.getSubject().onComplete();
        }
        this.emitter.onComplete();
        return false;
    }

    private final boolean onOpeningCompleted() {
        this.openingObserver.markCompleted();
        if (((Set)this.windows.getValue()).isEmpty()) {
            this.upstreamObserver.dispose();
            this.emitter.onComplete();
            return false;
        }
        return true;
    }

    private final boolean onDownstreamDisposed() {
        this.openingObserver.dispose();
        if (((Set)this.windows.getValue()).isEmpty()) {
            this.upstreamObserver.dispose();
            return false;
        }
        return true;
    }

    private final boolean onError(Throwable error) {
        this.upstreamObserver.dispose();
        this.openingObserver.dispose();
        this.emitter.onError(error);
        Iterable $this$forEach$iv = (Iterable)AtomicReferenceExtKt.getAndSet(this.windows, (Object)SetsKt.emptySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClosingObserver it = (ClosingObserver)element$iv;
            boolean bl = false;
            it.dispose();
            it.getSubject().onError(error);
        }
        return false;
    }

    private final boolean onValue(T value) {
        Iterable $this$forEach$iv = (Iterable)this.windows.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClosingObserver it = (ClosingObserver)element$iv;
            boolean bl = false;
            it.getSubject().onNext(value);
            if (it.getCount().addAndGet(1L) != this.limit) continue;
            this.onClose(it);
            if (!this.restartOnLimit) continue;
            it.getCount().setValue(0L);
            this.open(it.getClosing());
        }
        return true;
    }

    public static final /* synthetic */ boolean access$processEvent(WindowBySignal $this, Object event) {
        return $this.processEvent(event);
    }

    public static final /* synthetic */ Serializer access$getActor$p(WindowBySignal $this) {
        return $this.actor;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\u0006\b\u0002\u0010\u0001 \u0001*\u0006\b\u0003\u0010\u0002 \u00012\u00020\u0003:\u0006\u0005\u0006\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0006\u000b\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "T", "S", "", "()V", "Close", "DownstreamDisposed", "Error", "Open", "OpeningCompleted", "UpstreamCompleted", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$Open;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$Close;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$UpstreamCompleted;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$OpeningCompleted;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$DownstreamDisposed;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event$Error;", "reaktive_debug"})
    private static abstract class Event<T, S> {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\u0018\u0000*\u0006\b\u0004\u0010\u0001 \u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$Open;", "S", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "reaktive_debug"})
        public static final class Open<S>
        extends Event {
            private final S value;

            public Open(S value) {
                super(null);
                this.value = value;
            }

            public final S getValue() {
                return this.value;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0004\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00040\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00040\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$Close;", "T", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "window", "Lcom/badoo/reaktive/observable/WindowBySignal$ClosingObserver;", "(Lcom/badoo/reaktive/observable/WindowBySignal$ClosingObserver;)V", "getWindow", "()Lcom/badoo/reaktive/observable/WindowBySignal$ClosingObserver;", "reaktive_debug"})
        public static final class Close<T>
        extends Event {
            @NotNull
            private final ClosingObserver<T> window;

            public Close(@NotNull ClosingObserver<T> window2) {
                Intrinsics.checkNotNullParameter(window2, (String)"window");
                super(null);
                this.window = window2;
            }

            @NotNull
            public final ClosingObserver<T> getWindow() {
                return this.window;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$UpstreamCompleted;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "()V", "reaktive_debug"})
        public static final class UpstreamCompleted
        extends Event {
            @NotNull
            public static final UpstreamCompleted INSTANCE = new UpstreamCompleted();

            private UpstreamCompleted() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$OpeningCompleted;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "()V", "reaktive_debug"})
        public static final class OpeningCompleted
        extends Event {
            @NotNull
            public static final OpeningCompleted INSTANCE = new OpeningCompleted();

            private OpeningCompleted() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$DownstreamDisposed;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "()V", "reaktive_debug"})
        public static final class DownstreamDisposed
        extends Event {
            @NotNull
            public static final DownstreamDisposed INSTANCE = new DownstreamDisposed();

            private DownstreamDisposed() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$Event$Error;", "Lcom/badoo/reaktive/observable/WindowBySignal$Event;", "", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "reaktive_debug"})
        public static final class Error
        extends Event {
            @NotNull
            private final Throwable error;

            public Error(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0002\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$WindowWrapper;", "T", "Lcom/badoo/reaktive/observable/Observable;", "delegate", "(Lcom/badoo/reaktive/observable/Observable;)V", "isSubscribed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "()Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "subscribe", "", "observer", "Lcom/badoo/reaktive/observable/ObservableObserver;", "reaktive_debug"})
    private static final class WindowWrapper<T>
    implements Observable<T> {
        @NotNull
        private final Observable<T> delegate;
        @NotNull
        private final AtomicBoolean isSubscribed;

        public WindowWrapper(@NotNull Observable<? extends T> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
            this.isSubscribed = new AtomicBoolean(false, 1, null);
        }

        @NotNull
        public final AtomicBoolean isSubscribed() {
            return this.isSubscribed;
        }

        @Override
        public void subscribe(@NotNull ObservableObserver<? super T> observer2) {
            Intrinsics.checkNotNullParameter(observer2, (String)"observer");
            this.isSubscribed.setValue(true);
            this.delegate.subscribe(observer2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$AbstractObserver;", "Lcom/badoo/reaktive/base/Observer;", "Lcom/badoo/reaktive/base/ErrorCallback;", "Lcom/badoo/reaktive/disposable/SerialDisposable;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "isCompleted", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "isDone", "", "markCompleted", "", "onError", "error", "", "onSubscribe", "disposable", "Lcom/badoo/reaktive/disposable/Disposable;", "reaktive_debug"})
    private static abstract class AbstractObserver
    extends SerialDisposable
    implements Observer,
    ErrorCallback {
        @NotNull
        private final Serializer<Object> actor;
        @NotNull
        private AtomicBoolean isCompleted;

        public AbstractObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            this.actor = actor;
            this.isCompleted = new AtomicBoolean(false, 1, null);
        }

        public final void markCompleted() {
            this.isCompleted.setValue(true);
        }

        public final boolean isDone() {
            return this.isCompleted.getValue() || this.isDisposed();
        }

        @Override
        public void onSubscribe(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.set(disposable);
        }

        @Override
        public void onError(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.actor.accept(new Event.Error(error));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$UpstreamObserver;", "T", "Lcom/badoo/reaktive/observable/WindowBySignal$AbstractObserver;", "Lcom/badoo/reaktive/observable/ObservableObserver;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "onComplete", "", "onNext", "value", "(Ljava/lang/Object;)V", "reaktive_debug"})
    private static final class UpstreamObserver<T>
    extends AbstractObserver
    implements ObservableObserver<T> {
        @NotNull
        private final Serializer<Object> actor;

        public UpstreamObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            super(actor);
            this.actor = actor;
        }

        @Override
        public void onNext(T value) {
            this.actor.accept(value);
        }

        @Override
        public void onComplete() {
            this.actor.accept(Event.UpstreamCompleted.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$OpeningObserver;", "S", "Lcom/badoo/reaktive/observable/WindowBySignal$AbstractObserver;", "Lcom/badoo/reaktive/observable/ObservableObserver;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "onComplete", "", "onNext", "value", "(Ljava/lang/Object;)V", "reaktive_debug"})
    private static final class OpeningObserver<S>
    extends AbstractObserver
    implements ObservableObserver<S> {
        @NotNull
        private final Serializer<Object> actor;

        public OpeningObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            super(actor);
            this.actor = actor;
        }

        @Override
        public void onNext(S value) {
            this.actor.accept(new Event.Open<S>(value));
        }

        @Override
        public void onComplete() {
            this.actor.accept(Event.OpeningCompleted.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u00022\u00020\u0003B+\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/badoo/reaktive/observable/WindowBySignal$ClosingObserver;", "T", "Lcom/badoo/reaktive/observable/WindowBySignal$AbstractObserver;", "Lcom/badoo/reaktive/completable/CompletableObserver;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "closing", "Lcom/badoo/reaktive/completable/Completable;", "subject", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "(Lcom/badoo/reaktive/utils/serializer/Serializer;Lcom/badoo/reaktive/completable/Completable;Lcom/badoo/reaktive/subject/unicast/UnicastSubject;)V", "getClosing", "()Lcom/badoo/reaktive/completable/Completable;", "count", "Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "getCount", "()Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "setCount", "(Lcom/badoo/reaktive/utils/atomic/AtomicLong;)V", "getSubject", "()Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "onComplete", "", "reaktive_debug"})
    private static final class ClosingObserver<T>
    extends AbstractObserver
    implements CompletableObserver {
        @NotNull
        private final Serializer<Object> actor;
        @NotNull
        private final Completable closing;
        @NotNull
        private final UnicastSubject<T> subject;
        @NotNull
        private AtomicLong count;

        public ClosingObserver(@NotNull Serializer<Object> actor, @NotNull Completable closing, @NotNull UnicastSubject<T> subject) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)closing, (String)"closing");
            Intrinsics.checkNotNullParameter(subject, (String)"subject");
            super(actor);
            this.actor = actor;
            this.closing = closing;
            this.subject = subject;
            this.count = new AtomicLong(0L, 1, null);
        }

        @NotNull
        public final Completable getClosing() {
            return this.closing;
        }

        @NotNull
        public final UnicastSubject<T> getSubject() {
            return this.subject;
        }

        @NotNull
        public final AtomicLong getCount() {
            return this.count;
        }

        public final void setCount(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
            this.count = atomicLong;
        }

        @Override
        public void onComplete() {
            this.actor.accept(new Event.Close(this));
        }
    }
}

