/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.blade.webapp;

import com.backbase.oss.blade.model.Blade;
import com.backbase.oss.blade.model.WebApp;
import com.backbase.oss.blade.tomcat.BladeHost;
import com.backbase.oss.blade.webapp.BladeRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.manager.ManagerServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BladeServlet
extends ManagerServlet {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BladeRegistry bladeRegistry = BladeRegistry.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(BladeServlet.class);

    private BladeHost getBladeHost() {
        return (BladeHost)this.host;
    }

    private Host getHost() {
        return this.host;
    }

    public BladeServlet() {
        logger.info("Starting Blade Manager Servlet");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        Map blades = this.bladeRegistry.getBlades();
        String pathInfo = request.getPathInfo();
        if (pathInfo.startsWith("/api/status")) {
            String[] parts = pathInfo.split("/");
            if (parts.length == 3) {
                this.objectMapper.writeValue((OutputStream)response.getOutputStream(), blades.values());
            } else if (parts.length == 4) {
                this.objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)this.bladeRegistry.get(parts[3]));
            }
        } else {
            super.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String body = this.read((InputStream)req.getInputStream());
        String pathInfo = req.getPathInfo();
        if ("/api/blades".equals(pathInfo)) {
            this.registerBlade(resp, body);
        } else if (pathInfo.startsWith("/api/start/")) {
            this.startWebApp(resp, pathInfo);
        } else if (pathInfo.startsWith("/api/stop/")) {
            this.stopWebApp(resp, pathInfo);
        }
    }

    private void stopWebApp(HttpServletResponse resp, String pathInfo) throws ServletException {
        WebApp webApp = this.getWebApp(pathInfo);
        if (webApp != null) {
            try {
                this.stop(webApp);
            }
            catch (LifecycleException e) {
                throw new ServletException("Cannot stop webapp: " + webApp.getName(), (Throwable)e);
            }
        } else {
            throw new ServletException("Invalid Request: " + pathInfo);
        }
        webApp.setStartupTime(Long.valueOf(0L));
        resp.setStatus(200);
    }

    private void startWebApp(HttpServletResponse resp, String pathInfo) throws ServletException {
        WebApp webApp = this.getWebApp(pathInfo);
        if (webApp != null) {
            try {
                this.start(webApp);
            }
            catch (LifecycleException e) {
                throw new ServletException("Cannot start webapp: " + webApp.getName(), (Throwable)e);
            }
        } else {
            throw new ServletException("Invalid request: " + pathInfo);
        }
        resp.setStatus(200);
    }

    private void registerBlade(HttpServletResponse resp, String body) throws IOException {
        Blade blade = (Blade)this.objectMapper.readValue(body, Blade.class);
        boolean isNew = this.bladeRegistry.hasBlade(blade.getId());
        this.bladeRegistry.put(blade);
        if (isNew) {
            resp.setStatus(201);
        } else {
            resp.setStatus(202);
        }
    }

    private WebApp getWebApp(String pathInfo) {
        String webAppName = pathInfo.substring(pathInfo.lastIndexOf(47));
        return this.bladeRegistry.find(webAppName);
    }

    private void stop(WebApp webApp) throws LifecycleException {
        logger.info("Stopping Web App: {}", (Object)webApp);
        Container child = this.getHost().findChild(webApp.getName());
        if (child != null) {
            child.stop();
            logger.info("Stopped Web App: {}", (Object)webApp);
        }
    }

    private void start(WebApp webApp) throws LifecycleException {
        logger.info("Starting Web App: {}", (Object)webApp);
        Container child = this.getHost().findChild(webApp.getName());
        if (child == null) {
            try {
                this.getBladeHost().deploy(webApp, true, Thread.currentThread().getContextClassLoader());
                logger.info("Started Web App: {}", (Object)webApp);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error deploying webApp: " + webApp, e);
            }
        } else {
            child.start();
        }
    }

    private String read(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }
}

