/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.blade.webapp;

import com.backbase.oss.blade.webapp.BladeRegistry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/blade_ws")
public class BladeServerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)BladeServerEndpoint.class.getName());
    private static final Set<Session> sessions = new LinkedHashSet();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final BladeRegistry bladeRegistry = BladeRegistry.getInstance();

    public BladeServerEndpoint() {
        bladeRegistry.addPropertyChangeListener(evt -> BladeServerEndpoint.sendText((Object)evt.getNewValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendText(Object message) {
        String text = null;
        try {
            text = objectMapper.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            logger.info("Cannot map object: {} to json message", message);
        }
        for (Session session : sessions) {
            if (!session.isOpen()) continue;
            try {
                Session session2 = session;
                synchronized (session2) {
                    session.getAsyncRemote().sendText(text);
                }
            }
            catch (IllegalStateException e) {
                sessions.remove(session);
                logger.info("Cannot send message: {} to client: {}", (Object)text, (Object)session.getId());
            }
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        logger.info("Received message from client: {} ", (Object)message);
    }

    @OnOpen
    public void onOpen(Session session) {
        sessions.add(session);
        BladeRegistry.getInstance().refresh();
        BladeServerEndpoint.sendText(BladeRegistry.getInstance().getBlades().values());
    }

    @OnClose
    public void onClose(Session session) {
        sessions.remove(session);
    }
}

