/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ApplicationServerFullResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.CentralServerFullResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DatabaseServerFullResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.NamingPatternType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SharedStorageResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ThreeTierCustomResourceNames;
import java.io.IOException;

public final class ThreeTierFullResourceNames
extends ThreeTierCustomResourceNames {
    private NamingPatternType namingPatternType = NamingPatternType.FULL_RESOURCE_NAME;
    private CentralServerFullResourceNames centralServer;
    private ApplicationServerFullResourceNames applicationServer;
    private DatabaseServerFullResourceNames databaseServer;
    private SharedStorageResourceNames sharedStorage;

    @Override
    public NamingPatternType namingPatternType() {
        return this.namingPatternType;
    }

    public CentralServerFullResourceNames centralServer() {
        return this.centralServer;
    }

    public ThreeTierFullResourceNames withCentralServer(CentralServerFullResourceNames centralServer) {
        this.centralServer = centralServer;
        return this;
    }

    public ApplicationServerFullResourceNames applicationServer() {
        return this.applicationServer;
    }

    public ThreeTierFullResourceNames withApplicationServer(ApplicationServerFullResourceNames applicationServer) {
        this.applicationServer = applicationServer;
        return this;
    }

    public DatabaseServerFullResourceNames databaseServer() {
        return this.databaseServer;
    }

    public ThreeTierFullResourceNames withDatabaseServer(DatabaseServerFullResourceNames databaseServer) {
        this.databaseServer = databaseServer;
        return this;
    }

    public SharedStorageResourceNames sharedStorage() {
        return this.sharedStorage;
    }

    public ThreeTierFullResourceNames withSharedStorage(SharedStorageResourceNames sharedStorage) {
        this.sharedStorage = sharedStorage;
        return this;
    }

    @Override
    public void validate() {
        if (this.centralServer() != null) {
            this.centralServer().validate();
        }
        if (this.applicationServer() != null) {
            this.applicationServer().validate();
        }
        if (this.databaseServer() != null) {
            this.databaseServer().validate();
        }
        if (this.sharedStorage() != null) {
            this.sharedStorage().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("namingPatternType", this.namingPatternType == null ? null : this.namingPatternType.toString());
        jsonWriter.writeJsonField("centralServer", (JsonSerializable)this.centralServer);
        jsonWriter.writeJsonField("applicationServer", (JsonSerializable)this.applicationServer);
        jsonWriter.writeJsonField("databaseServer", (JsonSerializable)this.databaseServer);
        jsonWriter.writeJsonField("sharedStorage", (JsonSerializable)this.sharedStorage);
        return jsonWriter.writeEndObject();
    }

    public static ThreeTierFullResourceNames fromJson(JsonReader jsonReader) throws IOException {
        return (ThreeTierFullResourceNames)jsonReader.readObject(reader -> {
            ThreeTierFullResourceNames deserializedThreeTierFullResourceNames = new ThreeTierFullResourceNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("namingPatternType".equals(fieldName)) {
                    deserializedThreeTierFullResourceNames.namingPatternType = NamingPatternType.fromString(reader.getString());
                    continue;
                }
                if ("centralServer".equals(fieldName)) {
                    deserializedThreeTierFullResourceNames.centralServer = CentralServerFullResourceNames.fromJson(reader);
                    continue;
                }
                if ("applicationServer".equals(fieldName)) {
                    deserializedThreeTierFullResourceNames.applicationServer = ApplicationServerFullResourceNames.fromJson(reader);
                    continue;
                }
                if ("databaseServer".equals(fieldName)) {
                    deserializedThreeTierFullResourceNames.databaseServer = DatabaseServerFullResourceNames.fromJson(reader);
                    continue;
                }
                if ("sharedStorage".equals(fieldName)) {
                    deserializedThreeTierFullResourceNames.sharedStorage = SharedStorageResourceNames.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThreeTierFullResourceNames;
        });
    }
}

