/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DatabaseVmDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.LoadBalancerDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceError;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceStatus;
import java.io.IOException;
import java.util.List;

public final class SapDatabaseProperties
implements JsonSerializable<SapDatabaseProperties> {
    private String subnet;
    private String databaseSid;
    private String databaseType;
    private String ipAddress;
    private LoadBalancerDetails loadBalancerDetails;
    private List<DatabaseVmDetails> vmDetails;
    private SapVirtualInstanceStatus status;
    private SapVirtualInstanceProvisioningState provisioningState;
    private SapVirtualInstanceError errors;

    public String subnet() {
        return this.subnet;
    }

    public String databaseSid() {
        return this.databaseSid;
    }

    public String databaseType() {
        return this.databaseType;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public LoadBalancerDetails loadBalancerDetails() {
        return this.loadBalancerDetails;
    }

    public List<DatabaseVmDetails> vmDetails() {
        return this.vmDetails;
    }

    public SapVirtualInstanceStatus status() {
        return this.status;
    }

    public SapVirtualInstanceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SapVirtualInstanceError errors() {
        return this.errors;
    }

    public void validate() {
        if (this.loadBalancerDetails() != null) {
            this.loadBalancerDetails().validate();
        }
        if (this.vmDetails() != null) {
            this.vmDetails().forEach(e -> e.validate());
        }
        if (this.errors() != null) {
            this.errors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SapDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapDatabaseProperties)jsonReader.readObject(reader -> {
            SapDatabaseProperties deserializedSapDatabaseProperties = new SapDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedSapDatabaseProperties.subnet = reader.getString();
                    continue;
                }
                if ("databaseSid".equals(fieldName)) {
                    deserializedSapDatabaseProperties.databaseSid = reader.getString();
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSapDatabaseProperties.databaseType = reader.getString();
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedSapDatabaseProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("loadBalancerDetails".equals(fieldName)) {
                    deserializedSapDatabaseProperties.loadBalancerDetails = LoadBalancerDetails.fromJson(reader);
                    continue;
                }
                if ("vmDetails".equals(fieldName)) {
                    List vmDetails;
                    deserializedSapDatabaseProperties.vmDetails = vmDetails = reader.readArray(reader1 -> DatabaseVmDetails.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSapDatabaseProperties.status = SapVirtualInstanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSapDatabaseProperties.provisioningState = SapVirtualInstanceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedSapDatabaseProperties.errors = SapVirtualInstanceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapDatabaseProperties;
        });
    }
}

