/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.CentralServerVmDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.EnqueueReplicationServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.EnqueueServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.GatewayServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.LoadBalancerDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.MessageServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHealthState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceError;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceStatus;
import java.io.IOException;
import java.util.List;

public final class SapCentralServerProperties
implements JsonSerializable<SapCentralServerProperties> {
    private String instanceNo;
    private String subnet;
    private MessageServerProperties messageServerProperties;
    private EnqueueServerProperties enqueueServerProperties;
    private GatewayServerProperties gatewayServerProperties;
    private EnqueueReplicationServerProperties enqueueReplicationServerProperties;
    private String kernelVersion;
    private String kernelPatch;
    private LoadBalancerDetails loadBalancerDetails;
    private List<CentralServerVmDetails> vmDetails;
    private SapVirtualInstanceStatus status;
    private SapHealthState health;
    private SapVirtualInstanceProvisioningState provisioningState;
    private SapVirtualInstanceError errors;

    public String instanceNo() {
        return this.instanceNo;
    }

    public String subnet() {
        return this.subnet;
    }

    public MessageServerProperties messageServerProperties() {
        return this.messageServerProperties;
    }

    public SapCentralServerProperties withMessageServerProperties(MessageServerProperties messageServerProperties) {
        this.messageServerProperties = messageServerProperties;
        return this;
    }

    public EnqueueServerProperties enqueueServerProperties() {
        return this.enqueueServerProperties;
    }

    public SapCentralServerProperties withEnqueueServerProperties(EnqueueServerProperties enqueueServerProperties) {
        this.enqueueServerProperties = enqueueServerProperties;
        return this;
    }

    public GatewayServerProperties gatewayServerProperties() {
        return this.gatewayServerProperties;
    }

    public SapCentralServerProperties withGatewayServerProperties(GatewayServerProperties gatewayServerProperties) {
        this.gatewayServerProperties = gatewayServerProperties;
        return this;
    }

    public EnqueueReplicationServerProperties enqueueReplicationServerProperties() {
        return this.enqueueReplicationServerProperties;
    }

    public SapCentralServerProperties withEnqueueReplicationServerProperties(EnqueueReplicationServerProperties enqueueReplicationServerProperties) {
        this.enqueueReplicationServerProperties = enqueueReplicationServerProperties;
        return this;
    }

    public String kernelVersion() {
        return this.kernelVersion;
    }

    public String kernelPatch() {
        return this.kernelPatch;
    }

    public LoadBalancerDetails loadBalancerDetails() {
        return this.loadBalancerDetails;
    }

    public List<CentralServerVmDetails> vmDetails() {
        return this.vmDetails;
    }

    public SapVirtualInstanceStatus status() {
        return this.status;
    }

    public SapHealthState health() {
        return this.health;
    }

    public SapVirtualInstanceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SapVirtualInstanceError errors() {
        return this.errors;
    }

    public void validate() {
        if (this.messageServerProperties() != null) {
            this.messageServerProperties().validate();
        }
        if (this.enqueueServerProperties() != null) {
            this.enqueueServerProperties().validate();
        }
        if (this.gatewayServerProperties() != null) {
            this.gatewayServerProperties().validate();
        }
        if (this.enqueueReplicationServerProperties() != null) {
            this.enqueueReplicationServerProperties().validate();
        }
        if (this.loadBalancerDetails() != null) {
            this.loadBalancerDetails().validate();
        }
        if (this.vmDetails() != null) {
            this.vmDetails().forEach(e -> e.validate());
        }
        if (this.errors() != null) {
            this.errors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("messageServerProperties", (JsonSerializable)this.messageServerProperties);
        jsonWriter.writeJsonField("enqueueServerProperties", (JsonSerializable)this.enqueueServerProperties);
        jsonWriter.writeJsonField("gatewayServerProperties", (JsonSerializable)this.gatewayServerProperties);
        jsonWriter.writeJsonField("enqueueReplicationServerProperties", (JsonSerializable)this.enqueueReplicationServerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SapCentralServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapCentralServerProperties)jsonReader.readObject(reader -> {
            SapCentralServerProperties deserializedSapCentralServerProperties = new SapCentralServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceNo".equals(fieldName)) {
                    deserializedSapCentralServerProperties.instanceNo = reader.getString();
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedSapCentralServerProperties.subnet = reader.getString();
                    continue;
                }
                if ("messageServerProperties".equals(fieldName)) {
                    deserializedSapCentralServerProperties.messageServerProperties = MessageServerProperties.fromJson(reader);
                    continue;
                }
                if ("enqueueServerProperties".equals(fieldName)) {
                    deserializedSapCentralServerProperties.enqueueServerProperties = EnqueueServerProperties.fromJson(reader);
                    continue;
                }
                if ("gatewayServerProperties".equals(fieldName)) {
                    deserializedSapCentralServerProperties.gatewayServerProperties = GatewayServerProperties.fromJson(reader);
                    continue;
                }
                if ("enqueueReplicationServerProperties".equals(fieldName)) {
                    deserializedSapCentralServerProperties.enqueueReplicationServerProperties = EnqueueReplicationServerProperties.fromJson(reader);
                    continue;
                }
                if ("kernelVersion".equals(fieldName)) {
                    deserializedSapCentralServerProperties.kernelVersion = reader.getString();
                    continue;
                }
                if ("kernelPatch".equals(fieldName)) {
                    deserializedSapCentralServerProperties.kernelPatch = reader.getString();
                    continue;
                }
                if ("loadBalancerDetails".equals(fieldName)) {
                    deserializedSapCentralServerProperties.loadBalancerDetails = LoadBalancerDetails.fromJson(reader);
                    continue;
                }
                if ("vmDetails".equals(fieldName)) {
                    List vmDetails;
                    deserializedSapCentralServerProperties.vmDetails = vmDetails = reader.readArray(reader1 -> CentralServerVmDetails.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSapCentralServerProperties.status = SapVirtualInstanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedSapCentralServerProperties.health = SapHealthState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSapCentralServerProperties.provisioningState = SapVirtualInstanceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedSapCentralServerProperties.errors = SapVirtualInstanceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapCentralServerProperties;
        });
    }
}

