/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OSConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OSType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SshConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SshKeyPair;
import java.io.IOException;

public final class LinuxConfiguration
extends OSConfiguration {
    private OSType osType = OSType.LINUX;
    private Boolean disablePasswordAuthentication;
    private SshConfiguration ssh;
    private SshKeyPair sshKeyPair;

    @Override
    public OSType osType() {
        return this.osType;
    }

    public Boolean disablePasswordAuthentication() {
        return this.disablePasswordAuthentication;
    }

    public LinuxConfiguration withDisablePasswordAuthentication(Boolean disablePasswordAuthentication) {
        this.disablePasswordAuthentication = disablePasswordAuthentication;
        return this;
    }

    public SshConfiguration ssh() {
        return this.ssh;
    }

    public LinuxConfiguration withSsh(SshConfiguration ssh) {
        this.ssh = ssh;
        return this;
    }

    public SshKeyPair sshKeyPair() {
        return this.sshKeyPair;
    }

    public LinuxConfiguration withSshKeyPair(SshKeyPair sshKeyPair) {
        this.sshKeyPair = sshKeyPair;
        return this;
    }

    @Override
    public void validate() {
        if (this.ssh() != null) {
            this.ssh().validate();
        }
        if (this.sshKeyPair() != null) {
            this.sshKeyPair().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeBooleanField("disablePasswordAuthentication", this.disablePasswordAuthentication);
        jsonWriter.writeJsonField("ssh", (JsonSerializable)this.ssh);
        jsonWriter.writeJsonField("sshKeyPair", (JsonSerializable)this.sshKeyPair);
        return jsonWriter.writeEndObject();
    }

    public static LinuxConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LinuxConfiguration)jsonReader.readObject(reader -> {
            LinuxConfiguration deserializedLinuxConfiguration = new LinuxConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedLinuxConfiguration.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("disablePasswordAuthentication".equals(fieldName)) {
                    deserializedLinuxConfiguration.disablePasswordAuthentication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ssh".equals(fieldName)) {
                    deserializedLinuxConfiguration.ssh = SshConfiguration.fromJson(reader);
                    continue;
                }
                if ("sshKeyPair".equals(fieldName)) {
                    deserializedLinuxConfiguration.sshKeyPair = SshKeyPair.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinuxConfiguration;
        });
    }
}

