/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class HighAvailabilitySoftwareConfiguration
implements JsonSerializable<HighAvailabilitySoftwareConfiguration> {
    private String fencingClientId;
    private String fencingClientPassword;
    private static final ClientLogger LOGGER = new ClientLogger(HighAvailabilitySoftwareConfiguration.class);

    public String fencingClientId() {
        return this.fencingClientId;
    }

    public HighAvailabilitySoftwareConfiguration withFencingClientId(String fencingClientId) {
        this.fencingClientId = fencingClientId;
        return this;
    }

    public String fencingClientPassword() {
        return this.fencingClientPassword;
    }

    public HighAvailabilitySoftwareConfiguration withFencingClientPassword(String fencingClientPassword) {
        this.fencingClientPassword = fencingClientPassword;
        return this;
    }

    public void validate() {
        if (this.fencingClientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fencingClientId in model HighAvailabilitySoftwareConfiguration"));
        }
        if (this.fencingClientPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fencingClientPassword in model HighAvailabilitySoftwareConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fencingClientId", this.fencingClientId);
        jsonWriter.writeStringField("fencingClientPassword", this.fencingClientPassword);
        return jsonWriter.writeEndObject();
    }

    public static HighAvailabilitySoftwareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (HighAvailabilitySoftwareConfiguration)jsonReader.readObject(reader -> {
            HighAvailabilitySoftwareConfiguration deserializedHighAvailabilitySoftwareConfiguration = new HighAvailabilitySoftwareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fencingClientId".equals(fieldName)) {
                    deserializedHighAvailabilitySoftwareConfiguration.fencingClientId = reader.getString();
                    continue;
                }
                if ("fencingClientPassword".equals(fieldName)) {
                    deserializedHighAvailabilitySoftwareConfiguration.fencingClientPassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHighAvailabilitySoftwareConfiguration;
        });
    }
}

