/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskSku;
import java.io.IOException;

public final class DiskVolumeConfiguration
implements JsonSerializable<DiskVolumeConfiguration> {
    private Long count;
    private Long sizeGB;
    private DiskSku sku;

    public Long count() {
        return this.count;
    }

    public DiskVolumeConfiguration withCount(Long count) {
        this.count = count;
        return this;
    }

    public Long sizeGB() {
        return this.sizeGB;
    }

    public DiskVolumeConfiguration withSizeGB(Long sizeGB) {
        this.sizeGB = sizeGB;
        return this;
    }

    public DiskSku sku() {
        return this.sku;
    }

    public DiskVolumeConfiguration withSku(DiskSku sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeNumberField("sizeGB", (Number)this.sizeGB);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static DiskVolumeConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DiskVolumeConfiguration)jsonReader.readObject(reader -> {
            DiskVolumeConfiguration deserializedDiskVolumeConfiguration = new DiskVolumeConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedDiskVolumeConfiguration.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sizeGB".equals(fieldName)) {
                    deserializedDiskVolumeConfiguration.sizeGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDiskVolumeConfiguration.sku = DiskSku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskVolumeConfiguration;
        });
    }
}

