/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapApplicationServerInstanceInner;
import java.io.IOException;
import java.util.List;

public final class SAPApplicationServerInstanceListResult
implements JsonSerializable<SAPApplicationServerInstanceListResult> {
    private List<SapApplicationServerInstanceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SAPApplicationServerInstanceListResult.class);

    private SAPApplicationServerInstanceListResult() {
    }

    public List<SapApplicationServerInstanceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SAPApplicationServerInstanceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SAPApplicationServerInstanceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SAPApplicationServerInstanceListResult)jsonReader.readObject(reader -> {
            SAPApplicationServerInstanceListResult deserializedSAPApplicationServerInstanceListResult = new SAPApplicationServerInstanceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSAPApplicationServerInstanceListResult.value = value = reader.readArray(reader1 -> SapApplicationServerInstanceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSAPApplicationServerInstanceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSAPApplicationServerInstanceListResult;
        });
    }
}

