/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.RecommendedActionCurrentState;
import com.azure.resourcemanager.sql.models.RecommendedActionInitiatedBy;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RecommendedActionStateInfo
implements JsonSerializable<RecommendedActionStateInfo> {
    private RecommendedActionCurrentState currentValue;
    private RecommendedActionInitiatedBy actionInitiatedBy;
    private OffsetDateTime lastModified;
    private static final ClientLogger LOGGER = new ClientLogger(RecommendedActionStateInfo.class);

    public RecommendedActionCurrentState currentValue() {
        return this.currentValue;
    }

    public RecommendedActionStateInfo withCurrentValue(RecommendedActionCurrentState currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public RecommendedActionInitiatedBy actionInitiatedBy() {
        return this.actionInitiatedBy;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public void validate() {
        if (this.currentValue() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property currentValue in model RecommendedActionStateInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("currentValue", this.currentValue == null ? null : this.currentValue.toString());
        return jsonWriter.writeEndObject();
    }

    public static RecommendedActionStateInfo fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendedActionStateInfo)jsonReader.readObject(reader -> {
            RecommendedActionStateInfo deserializedRecommendedActionStateInfo = new RecommendedActionStateInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentValue".equals(fieldName)) {
                    deserializedRecommendedActionStateInfo.currentValue = RecommendedActionCurrentState.fromString(reader.getString());
                    continue;
                }
                if ("actionInitiatedBy".equals(fieldName)) {
                    deserializedRecommendedActionStateInfo.actionInitiatedBy = RecommendedActionInitiatedBy.fromString(reader.getString());
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedRecommendedActionStateInfo.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendedActionStateInfo;
        });
    }
}

