/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.MetricInner;
import java.io.IOException;
import java.util.List;

public final class MetricListResult
implements JsonSerializable<MetricListResult> {
    private List<MetricInner> value;
    private static final ClientLogger LOGGER = new ClientLogger(MetricListResult.class);

    public List<MetricInner> value() {
        return this.value;
    }

    public MetricListResult withValue(List<MetricInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model MetricListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricListResult fromJson(JsonReader jsonReader) throws IOException {
        return (MetricListResult)jsonReader.readObject(reader -> {
            MetricListResult deserializedMetricListResult = new MetricListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMetricListResult.value = value = reader.readArray(reader1 -> MetricInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricListResult;
        });
    }
}

