/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseQueriesClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceQueryInner;
import com.azure.resourcemanager.sql.fluent.models.QueryStatisticsInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ManagedInstanceQueryStatistics;
import com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import reactor.core.publisher.Mono;

public final class ManagedDatabaseQueriesClientImpl
implements ManagedDatabaseQueriesClient {
    private final ManagedDatabaseQueriesService service;
    private final SqlManagementClientImpl client;

    ManagedDatabaseQueriesClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseQueriesService)RestProxy.create(ManagedDatabaseQueriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedInstanceQueryInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (queryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, queryId, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedInstanceQueryInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (queryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, queryId, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceQueryInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, queryId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedInstanceQueryInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedInstanceQueryInner> getWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, queryId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceQueryInner get(String resourceGroupName, String managedInstanceName, String databaseName, String queryId) {
        return (ManagedInstanceQueryInner)((Object)this.getWithResponse(resourceGroupName, managedInstanceName, databaseName, queryId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryStatisticsInner>> listByQuerySinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, String startTime, String endTime, QueryTimeGrainType interval) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (queryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByQuery(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceQueryStatistics)res.getValue()).value(), ((ManagedInstanceQueryStatistics)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryStatisticsInner>> listByQuerySinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, String startTime, String endTime, QueryTimeGrainType interval, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (queryId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByQuery(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceQueryStatistics)res.getValue()).value(), ((ManagedInstanceQueryStatistics)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueryStatisticsInner> listByQueryAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, String startTime, String endTime, QueryTimeGrainType interval) {
        return new PagedFlux(() -> this.listByQuerySinglePageAsync(resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval), nextLink -> this.listByQueryNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueryStatisticsInner> listByQueryAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId) {
        String startTime = null;
        String endTime = null;
        QueryTimeGrainType interval = null;
        return new PagedFlux(() -> this.listByQuerySinglePageAsync(resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval), nextLink -> this.listByQueryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<QueryStatisticsInner> listByQueryAsync(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, String startTime, String endTime, QueryTimeGrainType interval, Context context) {
        return new PagedFlux(() -> this.listByQuerySinglePageAsync(resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval, context), nextLink -> this.listByQueryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueryStatisticsInner> listByQuery(String resourceGroupName, String managedInstanceName, String databaseName, String queryId) {
        String startTime = null;
        String endTime = null;
        QueryTimeGrainType interval = null;
        return new PagedIterable(this.listByQueryAsync(resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueryStatisticsInner> listByQuery(String resourceGroupName, String managedInstanceName, String databaseName, String queryId, String startTime, String endTime, QueryTimeGrainType interval, Context context) {
        return new PagedIterable(this.listByQueryAsync(resourceGroupName, managedInstanceName, databaseName, queryId, startTime, endTime, interval, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryStatisticsInner>> listByQueryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByQueryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceQueryStatistics)res.getValue()).value(), ((ManagedInstanceQueryStatistics)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryStatisticsInner>> listByQueryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByQueryNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceQueryStatistics)res.getValue()).value(), ((ManagedInstanceQueryStatistics)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientManagedDatabaseQueries")
    public static interface ManagedDatabaseQueriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/queries/{queryId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceQueryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="queryId") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/queries/{queryId}/statistics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceQueryStatistics>> listByQuery(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="queryId") String var5, @QueryParam(value="startTime") String var6, @QueryParam(value="endTime") String var7, @QueryParam(value="interval") QueryTimeGrainType var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceQueryStatistics>> listByQueryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

