/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.VirtualClusterProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualClusterInner
extends Resource {
    private VirtualClusterProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private VirtualClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VirtualClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public VirtualClusterInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualClusterProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public List<String> childResources() {
        return this.innerProperties() == null ? null : this.innerProperties().childResources();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualClusterInner)((Object)jsonReader.readObject(reader -> {
            VirtualClusterInner deserializedVirtualClusterInner = new VirtualClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualClusterInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualClusterInner.innerProperties = VirtualClusterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualClusterInner;
        }));
    }
}

