/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.DatabaseKey;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class RestorableDroppedDatabaseProperties
implements JsonSerializable<RestorableDroppedDatabaseProperties> {
    private String databaseName;
    private Long maxSizeBytes;
    private OffsetDateTime creationDate;
    private OffsetDateTime deletionDate;
    private OffsetDateTime earliestRestoreDate;
    private BackupStorageRedundancy backupStorageRedundancy;
    private Map<String, DatabaseKey> keys;

    public String databaseName() {
        return this.databaseName;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    public Map<String, DatabaseKey> keys() {
        return this.keys;
    }

    public RestorableDroppedDatabaseProperties withKeys(Map<String, DatabaseKey> keys) {
        this.keys = keys;
        return this;
    }

    public void validate() {
        if (this.keys() != null) {
            this.keys().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("keys", this.keys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RestorableDroppedDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableDroppedDatabaseProperties)jsonReader.readObject(reader -> {
            RestorableDroppedDatabaseProperties deserializedRestorableDroppedDatabaseProperties = new RestorableDroppedDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.databaseName = reader.getString();
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.maxSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deletionDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.deletionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.backupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("keys".equals(fieldName)) {
                    Map keys;
                    deserializedRestorableDroppedDatabaseProperties.keys = keys = reader.readMap(reader1 -> DatabaseKey.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableDroppedDatabaseProperties;
        });
    }
}

