/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.RecommendedActionProperties;
import com.azure.resourcemanager.sql.models.RecommendedActionErrorInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionImpactRecord;
import com.azure.resourcemanager.sql.models.RecommendedActionImplementationInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionInitiatedBy;
import com.azure.resourcemanager.sql.models.RecommendedActionMetricInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionStateInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class RecommendedActionInner
extends ProxyResource {
    private String kind;
    private String location;
    private RecommendedActionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String kind() {
        return this.kind;
    }

    public String location() {
        return this.location;
    }

    private RecommendedActionProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String recommendationReason() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationReason();
    }

    public OffsetDateTime validSince() {
        return this.innerProperties() == null ? null : this.innerProperties().validSince();
    }

    public OffsetDateTime lastRefresh() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRefresh();
    }

    public RecommendedActionStateInfo state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public RecommendedActionInner withState(RecommendedActionStateInfo state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedActionProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Boolean isExecutableAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isExecutableAction();
    }

    public Boolean isRevertableAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isRevertableAction();
    }

    public Boolean isArchivedAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isArchivedAction();
    }

    public OffsetDateTime executeActionStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionStartTime();
    }

    public String executeActionDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionDuration();
    }

    public OffsetDateTime revertActionStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionStartTime();
    }

    public String revertActionDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionDuration();
    }

    public RecommendedActionInitiatedBy executeActionInitiatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionInitiatedBy();
    }

    public OffsetDateTime executeActionInitiatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionInitiatedTime();
    }

    public RecommendedActionInitiatedBy revertActionInitiatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionInitiatedBy();
    }

    public OffsetDateTime revertActionInitiatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionInitiatedTime();
    }

    public Integer score() {
        return this.innerProperties() == null ? null : this.innerProperties().score();
    }

    public RecommendedActionImplementationInfo implementationDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().implementationDetails();
    }

    public RecommendedActionErrorInfo errorDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().errorDetails();
    }

    public List<RecommendedActionImpactRecord> estimatedImpact() {
        return this.innerProperties() == null ? null : this.innerProperties().estimatedImpact();
    }

    public List<RecommendedActionImpactRecord> observedImpact() {
        return this.innerProperties() == null ? null : this.innerProperties().observedImpact();
    }

    public List<RecommendedActionMetricInfo> timeSeries() {
        return this.innerProperties() == null ? null : this.innerProperties().timeSeries();
    }

    public List<String> linkedObjects() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedObjects();
    }

    public Map<String, Object> details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RecommendedActionInner fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendedActionInner)((Object)jsonReader.readObject(reader -> {
            RecommendedActionInner deserializedRecommendedActionInner = new RecommendedActionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRecommendedActionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRecommendedActionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRecommendedActionInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedRecommendedActionInner.kind = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRecommendedActionInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRecommendedActionInner.innerProperties = RecommendedActionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendedActionInner;
        }));
    }
}

