/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolDatabaseActivityProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class ElasticPoolDatabaseActivityInner
extends ProxyResource {
    private String location;
    private ElasticPoolDatabaseActivityProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public ElasticPoolDatabaseActivityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    private ElasticPoolDatabaseActivityProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public Integer errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    public Integer errorSeverity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorSeverity();
    }

    public String operation() {
        return this.innerProperties() == null ? null : this.innerProperties().operation();
    }

    public UUID operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    public String requestedElasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedElasticPoolName();
    }

    public String currentElasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentElasticPoolName();
    }

    public String currentServiceObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjective();
    }

    public String requestedServiceObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjective();
    }

    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolDatabaseActivityInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticPoolDatabaseActivityInner)((Object)jsonReader.readObject(reader -> {
            ElasticPoolDatabaseActivityInner deserializedElasticPoolDatabaseActivityInner = new ElasticPoolDatabaseActivityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticPoolDatabaseActivityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticPoolDatabaseActivityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticPoolDatabaseActivityInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticPoolDatabaseActivityInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticPoolDatabaseActivityInner.innerProperties = ElasticPoolDatabaseActivityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolDatabaseActivityInner;
        }));
    }
}

