/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerInfo;
import com.azure.resourcemanager.sql.models.ServerTrustGroupPropertiesTrustScopesItem;
import java.io.IOException;
import java.util.List;

public final class ServerTrustGroupProperties
implements JsonSerializable<ServerTrustGroupProperties> {
    private List<ServerInfo> groupMembers;
    private List<ServerTrustGroupPropertiesTrustScopesItem> trustScopes;
    private static final ClientLogger LOGGER = new ClientLogger(ServerTrustGroupProperties.class);

    public List<ServerInfo> groupMembers() {
        return this.groupMembers;
    }

    public ServerTrustGroupProperties withGroupMembers(List<ServerInfo> groupMembers) {
        this.groupMembers = groupMembers;
        return this;
    }

    public List<ServerTrustGroupPropertiesTrustScopesItem> trustScopes() {
        return this.trustScopes;
    }

    public ServerTrustGroupProperties withTrustScopes(List<ServerTrustGroupPropertiesTrustScopesItem> trustScopes) {
        this.trustScopes = trustScopes;
        return this;
    }

    public void validate() {
        if (this.groupMembers() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property groupMembers in model ServerTrustGroupProperties"));
        }
        this.groupMembers().forEach(e -> e.validate());
        if (this.trustScopes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property trustScopes in model ServerTrustGroupProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groupMembers", this.groupMembers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("trustScopes", this.trustScopes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ServerTrustGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerTrustGroupProperties)jsonReader.readObject(reader -> {
            ServerTrustGroupProperties deserializedServerTrustGroupProperties = new ServerTrustGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupMembers".equals(fieldName)) {
                    List groupMembers;
                    deserializedServerTrustGroupProperties.groupMembers = groupMembers = reader.readArray(reader1 -> ServerInfo.fromJson(reader1));
                    continue;
                }
                if ("trustScopes".equals(fieldName)) {
                    List trustScopes;
                    deserializedServerTrustGroupProperties.trustScopes = trustScopes = reader.readArray(reader1 -> ServerTrustGroupPropertiesTrustScopesItem.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerTrustGroupProperties;
        });
    }
}

