/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServicePrincipalType;
import java.io.IOException;

public final class ServicePrincipal
implements JsonSerializable<ServicePrincipal> {
    private String principalId;
    private String clientId;
    private String tenantId;
    private ServicePrincipalType type;

    public String principalId() {
        return this.principalId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ServicePrincipalType type() {
        return this.type;
    }

    public ServicePrincipal withType(ServicePrincipalType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServicePrincipal fromJson(JsonReader jsonReader) throws IOException {
        return (ServicePrincipal)jsonReader.readObject(reader -> {
            ServicePrincipal deserializedServicePrincipal = new ServicePrincipal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedServicePrincipal.principalId = reader.getString();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedServicePrincipal.clientId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedServicePrincipal.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServicePrincipal.type = ServicePrincipalType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServicePrincipal;
        });
    }
}

