/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ReplicationLinkType;
import com.azure.resourcemanager.sql.models.ReplicationRole;
import com.azure.resourcemanager.sql.models.ReplicationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ReplicationLinkProperties
implements JsonSerializable<ReplicationLinkProperties> {
    private String partnerServer;
    private String partnerDatabase;
    private String partnerLocation;
    private ReplicationRole role;
    private ReplicationRole partnerRole;
    private String replicationMode;
    private OffsetDateTime startTime;
    private Integer percentComplete;
    private ReplicationState replicationState;
    private Boolean isTerminationAllowed;
    private ReplicationLinkType linkType;

    public String partnerServer() {
        return this.partnerServer;
    }

    public String partnerDatabase() {
        return this.partnerDatabase;
    }

    public String partnerLocation() {
        return this.partnerLocation;
    }

    public ReplicationRole role() {
        return this.role;
    }

    public ReplicationRole partnerRole() {
        return this.partnerRole;
    }

    public String replicationMode() {
        return this.replicationMode;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public ReplicationState replicationState() {
        return this.replicationState;
    }

    public Boolean isTerminationAllowed() {
        return this.isTerminationAllowed;
    }

    public ReplicationLinkType linkType() {
        return this.linkType;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ReplicationLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationLinkProperties)jsonReader.readObject(reader -> {
            ReplicationLinkProperties deserializedReplicationLinkProperties = new ReplicationLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerServer".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerServer = reader.getString();
                    continue;
                }
                if ("partnerDatabase".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerDatabase = reader.getString();
                    continue;
                }
                if ("partnerLocation".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerLocation = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedReplicationLinkProperties.role = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("partnerRole".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedReplicationLinkProperties.replicationMode = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedReplicationLinkProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedReplicationLinkProperties.percentComplete = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("replicationState".equals(fieldName)) {
                    deserializedReplicationLinkProperties.replicationState = ReplicationState.fromString(reader.getString());
                    continue;
                }
                if ("isTerminationAllowed".equals(fieldName)) {
                    deserializedReplicationLinkProperties.isTerminationAllowed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("linkType".equals(fieldName)) {
                    deserializedReplicationLinkProperties.linkType = ReplicationLinkType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationLinkProperties;
        });
    }
}

