/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.JobStepOutputType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

public final class JobStepOutput {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(JobStepOutput.class);
    @JsonProperty(value="type")
    private JobStepOutputType type;
    @JsonProperty(value="subscriptionId")
    private UUID subscriptionId;
    @JsonProperty(value="resourceGroupName")
    private String resourceGroupName;
    @JsonProperty(value="serverName", required=true)
    private String serverName;
    @JsonProperty(value="databaseName", required=true)
    private String databaseName;
    @JsonProperty(value="schemaName")
    private String schemaName;
    @JsonProperty(value="tableName", required=true)
    private String tableName;
    @JsonProperty(value="credential", required=true)
    private String credential;

    public JobStepOutputType type() {
        return this.type;
    }

    public JobStepOutput withType(JobStepOutputType type) {
        this.type = type;
        return this;
    }

    public UUID subscriptionId() {
        return this.subscriptionId;
    }

    public JobStepOutput withSubscriptionId(UUID subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public JobStepOutput withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public JobStepOutput withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public JobStepOutput withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public JobStepOutput withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public JobStepOutput withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String credential() {
        return this.credential;
    }

    public JobStepOutput withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.serverName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serverName in model JobStepOutput"));
        }
        if (this.databaseName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model JobStepOutput"));
        }
        if (this.tableName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tableName in model JobStepOutput"));
        }
        if (this.credential() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property credential in model JobStepOutput"));
        }
    }
}

