/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseSensitivityLabelsClient;
import com.azure.resourcemanager.sql.fluent.models.SensitivityLabelInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SensitivityLabelListResult;
import com.azure.resourcemanager.sql.models.SensitivityLabelSource;
import reactor.core.publisher.Mono;

public final class ManagedDatabaseSensitivityLabelsClientImpl
implements ManagedDatabaseSensitivityLabelsClient {
    private final ClientLogger logger = new ClientLogger(ManagedDatabaseSensitivityLabelsClientImpl.class);
    private final ManagedDatabaseSensitivityLabelsService service;
    private final SqlManagementClientImpl client;

    ManagedDatabaseSensitivityLabelsClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseSensitivityLabelsService)RestProxy.create(ManagedDatabaseSensitivityLabelsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<SensitivityLabelInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (sensitivityLabelSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sensitivityLabelSource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource, this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SensitivityLabelInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (sensitivityLabelSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sensitivityLabelSource is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource, this.client.getSubscriptionId(), "2018-06-01-preview", context);
    }

    @Override
    public Mono<SensitivityLabelInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SensitivityLabelInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SensitivityLabelInner get(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource) {
        return (SensitivityLabelInner)((Object)this.getAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource).block());
    }

    @Override
    public Response<SensitivityLabelInner> getWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelSource sensitivityLabelSource, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, sensitivityLabelSource, context).block();
    }

    @Override
    public Mono<Response<SensitivityLabelInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String sensitivityLabelSource = "current";
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "current", this.client.getSubscriptionId(), "2018-06-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SensitivityLabelInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String sensitivityLabelSource = "current";
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "current", this.client.getSubscriptionId(), "2018-06-01-preview", parameters, context);
    }

    @Override
    public Mono<SensitivityLabelInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SensitivityLabelInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SensitivityLabelInner createOrUpdate(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters) {
        return (SensitivityLabelInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, parameters).block());
    }

    @Override
    public Response<SensitivityLabelInner> createOrUpdateWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, SensitivityLabelInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "current";
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "current", this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "current";
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "current", this.client.getSubscriptionId(), "2018-06-01-preview", context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        return this.deleteWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        this.deleteAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, context).block();
    }

    @Override
    public Mono<Response<Void>> disableRecommendationWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "recommended";
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.disableRecommendation(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "recommended", this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> disableRecommendationWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "recommended";
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.disableRecommendation(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "recommended", this.client.getSubscriptionId(), "2018-06-01-preview", context);
    }

    @Override
    public Mono<Void> disableRecommendationAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        return this.disableRecommendationWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableRecommendation(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        this.disableRecommendationAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).block();
    }

    @Override
    public Response<Void> disableRecommendationWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        return (Response)this.disableRecommendationWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, context).block();
    }

    @Override
    public Mono<Response<Void>> enableRecommendationWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "recommended";
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.enableRecommendation(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "recommended", this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> enableRecommendationWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (tableName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tableName is required and cannot be null."));
        }
        if (columnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter columnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String sensitivityLabelSource = "recommended";
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.enableRecommendation(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, "recommended", this.client.getSubscriptionId(), "2018-06-01-preview", context);
    }

    @Override
    public Mono<Void> enableRecommendationAsync(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        return this.enableRecommendationWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).flatMap(res -> Mono.empty());
    }

    @Override
    public void enableRecommendation(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName) {
        this.enableRecommendationAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName).block();
    }

    @Override
    public Response<Void> enableRecommendationWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, String schemaName, String tableName, String columnName, Context context) {
        return (Response)this.enableRecommendationWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, schemaName, tableName, columnName, context).block();
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listCurrentByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.listCurrentByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, filter, this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listCurrentByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listCurrentByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, filter, this.client.getSubscriptionId(), "2018-06-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SensitivityLabelInner> listCurrentByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String filter) {
        return new PagedFlux(() -> this.listCurrentByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, filter), nextLink -> this.listCurrentByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<SensitivityLabelInner> listCurrentByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        String filter = null;
        return new PagedFlux(() -> this.listCurrentByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, filter), nextLink -> this.listCurrentByDatabaseNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SensitivityLabelInner> listCurrentByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, String filter, Context context) {
        return new PagedFlux(() -> this.listCurrentByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, filter, context), nextLink -> this.listCurrentByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SensitivityLabelInner> listCurrentByDatabase(String resourceGroupName, String managedInstanceName, String databaseName, String filter, Context context) {
        return new PagedIterable(this.listCurrentByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, filter, context));
    }

    @Override
    public PagedIterable<SensitivityLabelInner> listCurrentByDatabase(String resourceGroupName, String managedInstanceName, String databaseName) {
        String filter = null;
        return new PagedIterable(this.listCurrentByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, filter));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listRecommendedByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, Boolean includeDisabledRecommendations, String skipToken, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.listRecommendedByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter, this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listRecommendedByDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String databaseName, Boolean includeDisabledRecommendations, String skipToken, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listRecommendedByDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter, this.client.getSubscriptionId(), "2018-06-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SensitivityLabelInner> listRecommendedByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Boolean includeDisabledRecommendations, String skipToken, String filter) {
        return new PagedFlux(() -> this.listRecommendedByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter), nextLink -> this.listRecommendedByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<SensitivityLabelInner> listRecommendedByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName) {
        Boolean includeDisabledRecommendations = null;
        String skipToken = null;
        String filter = null;
        return new PagedFlux(() -> this.listRecommendedByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter), nextLink -> this.listRecommendedByDatabaseNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SensitivityLabelInner> listRecommendedByDatabaseAsync(String resourceGroupName, String managedInstanceName, String databaseName, Boolean includeDisabledRecommendations, String skipToken, String filter, Context context) {
        return new PagedFlux(() -> this.listRecommendedByDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter, context), nextLink -> this.listRecommendedByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SensitivityLabelInner> listRecommendedByDatabase(String resourceGroupName, String managedInstanceName, String databaseName, Boolean includeDisabledRecommendations, String skipToken, String filter, Context context) {
        return new PagedIterable(this.listRecommendedByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter, context));
    }

    @Override
    public PagedIterable<SensitivityLabelInner> listRecommendedByDatabase(String resourceGroupName, String managedInstanceName, String databaseName) {
        Boolean includeDisabledRecommendations = null;
        String skipToken = null;
        String filter = null;
        return new PagedIterable(this.listRecommendedByDatabaseAsync(resourceGroupName, managedInstanceName, databaseName, includeDisabledRecommendations, skipToken, filter));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listCurrentByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listCurrentByDatabaseNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listCurrentByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listCurrentByDatabaseNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listRecommendedByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRecommendedByDatabaseNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SensitivityLabelInner>> listRecommendedByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRecommendedByDatabaseNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SensitivityLabelListResult)res.getValue()).value(), ((SensitivityLabelListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    private static interface ManagedDatabaseSensitivityLabelsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="sensitivityLabelSource") SensitivityLabelSource var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, Context var11);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="sensitivityLabelSource") String var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, @BodyParam(value="application/json") SensitivityLabelInner var11, Context var12);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="sensitivityLabelSource") String var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}/disable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> disableRecommendation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="sensitivityLabelSource") String var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}/enable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> enableRecommendation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="schemaName") String var5, @PathParam(value="tableName") String var6, @PathParam(value="columnName") String var7, @PathParam(value="sensitivityLabelSource") String var8, @PathParam(value="subscriptionId") String var9, @QueryParam(value="api-version") String var10, Context var11);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/currentSensitivityLabels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelListResult>> listCurrentByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/recommendedSensitivityLabels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelListResult>> listRecommendedByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="includeDisabledRecommendations") Boolean var5, @QueryParam(value="$skipToken") String var6, @QueryParam(value="$filter") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelListResult>> listCurrentByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SensitivityLabelListResult>> listRecommendedByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

